/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef PIXMAPCHOOSER_H
#define PIXMAPCHOOSER_H

#include <tqfiledialog.h>
#include <tqscrollview.h>
#include <tqpixmap.h>
#include <tqurl.h>

class FormWindow;

class PixmapView : public TQScrollView,
		   public TQFilePreview
{
    Q_OBJECT
  TQ_OBJECT

public:
    PixmapView( TQWidget *parent );
    void setPixmap( const TQPixmap &pix );
    void drawContents( TQPainter *p, int, int, int, int );
    void previewUrl( const TQUrl &u );

private:
    TQPixmap pixmap;

};

class ImageIconProvider : public TQFileIconProvider
{
    Q_OBJECT
  TQ_OBJECT

public:
    ImageIconProvider( TQWidget *parent = 0, const char *name = 0 );
    ~ImageIconProvider();

    const TQPixmap *pixmap( const TQFileInfo &fi );

private:
    TQStrList fmts;
    TQPixmap imagepm;

};

TQPixmap qChoosePixmap( TQWidget *parent, FormWindow *fw = 0, const TQPixmap &old = TQPixmap(),  TQString *fn = 0 );
TQStringList qChoosePixmaps( TQWidget *parent );


class PixmapChooser
{
public:
    enum Size { Mini, Small, Large, NoSize, Disabled };

    PixmapChooser();
    TQString pixmapPath( Size size ) const;

    static TQPixmap loadPixmap( const TQString &name, Size size = Small );

private:
    TQString smallPixDir;
    TQString largePixDir;
    TQString miniPixDir;
    TQString noSizePixDir;

};


#endif
