/***************************************************************************
                          functionsimpl.h - Function browser implementation 
                             -------------------
    copyright            : (C) 2004    Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_FUNCTIONSIMPL_H_
#define _HAVE_FUNCTIONSIMPL_H_

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqwidget.h>
#include <tqdict.h>

#include "functions.h"
#include "specialinformation.h"

class FunctionsDialog : public FunctionsDialogBase
{
  Q_OBJECT
  TQ_OBJECT
public:
  FunctionsDialog(TQWidget*, const TQDict<TQWidget>&, bool m_useInternalParser, char* = 0, bool = true);
  ~FunctionsDialog();
  // Return current content of text box
  TQString functionText() const;
  // Return current function and parameters
  TQString currentFunctionText();
public slots:
  // Update list of function availabe for given group
  void groupChanged(int);
  // Update syntax of chosen function
  void functionChanged(int);
  // Copy current function and parameters into text box
  void copyText();
  // Show widgets for current function's parameters
  void showParameters();
private:
  // Calculate current parameters
  TQString params();
  SpecialFunction m_function;
  int m_DCOP;
  int m_Slots;
  const TQDict<TQWidget> m_widgetList;
  TQStringList m_widgetNames;
  TQStringList m_widgetTypes;
  bool m_useInternalParser;
  TQStringList m_acceptedSlots;
  TQMap<TQString, TQString> m_slotList;
};  


#endif

