//
// C++ Implementation: resultlinkview
//
// Description:
//
//
// Author: Paulo Moura Guedes <moura@kdewebdev.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "resultview.h"
#include "../engine/linkstatus.h"

#include <tqpainter.h>
#include <tqcolor.h>

#include <klocale.h>
#include <kurl.h>
#include <kiconloader.h>

const TQString ResultView::URL_LABEL = "URL";
const TQString ResultView::STATUS_LABEL = "Status";
const TQString ResultView::MARKUP_LABEL = "Markup";
const TQString ResultView::LINK_LABEL_LABEL = "Label";


// ******************************* ResultView ********************************

ResultView::ResultView()
        : col_status_(-1),
        col_label_(-1),
        col_url_(-1),
        col_markup_(-1),
        sub_menu_(0),
        cell_tip_(0)
{}


ResultView::~ResultView()
{}

void ResultView::setColumns(TQStringList const& columns)
{
    Q_ASSERT(columns.size() != 0);
    
    columns_.clear();
    for(uint i = 0; i != columns.size(); ++i)
    {
        if(columns[i] == ResultView::URL_LABEL)
        {
            col_url_ = i + 1;
        }
        else if(columns[i] == ResultView::STATUS_LABEL)
        {
            col_status_ = i + 1;
        }
        else if(columns[i] == ResultView::MARKUP_LABEL)
        {
            col_markup_ = i + 1;
        }
        else if(columns[i] == ResultView::LINK_LABEL_LABEL)
        {
            col_label_ = i + 1;
        }

        columns_.push_back(columns[i]);
    }
    number_of_columns_ = columns.size();
}

bool ResultView::displayableWithtqStatus(LinktqStatus const* ls, tqStatus const& status)
{
    if(status == ResultView::good)
    {
        return 
                ls->status() == LinktqStatus::SUCCESSFULL ||
                ls->status() == LinktqStatus::HTTP_REDIRECTION;
    }
    else if(status == ResultView::bad)
    {
        return 
                ls->status() == LinktqStatus::BROKEN ||
                ls->status() == LinktqStatus::HTTP_CLIENT_ERROR ||
                ls->status() == LinktqStatus::HTTP_SERVER_ERROR;
    }
    else if(status == ResultView::malformed)
    {
        return ls->status() == LinktqStatus::MALFORMED;
    }
    else if(status == ResultView::undetermined)
    {
        return 
                ls->status() == LinktqStatus::UNDETERMINED ||
                ls->status() == LinktqStatus::TIMEOUT ||
                ls->status() == LinktqStatus::NOT_SUPPORTED;
    }
    else
        return true;
}


// ******************************* ResultViewItem *****************************

ResultViewItem::ResultViewItem(LinktqStatus const* linkstatus, int column_index)
        : ls_((LinktqStatus*)linkstatus), column_index_(column_index)
{
    Q_ASSERT(ls_);
    Q_ASSERT(column_index_ > 0);
}

ResultViewItem::~ResultViewItem()
{}

void ResultViewItem::setColumnIndex(int i)
{
    Q_ASSERT(i > 0);
    column_index_ = i;
}

int ResultViewItem::columnIndex() const
{
    return column_index_;
}

LinktqStatus const* ResultViewItem::linktqStatus() const
{
    Q_ASSERT(ls_);
    return ls_;
}

TQColor const& ResultViewItem::textStatusColor() const
{
    if(linktqStatus()->errorOccurred())
    {
        //kdDebug(23100) <<  "ERROR: " << linkStatus()->error() << ": " << linktqStatus()->absoluteUrl().prettyURL() << endl;
        if(linktqStatus()->error() == i18n( "Javascript not supported" ))
            return TQt::lightGray;
        else
            return TQt::red;
    }

    else if(linktqStatus()->absoluteUrl().hasRef())
        return TQt::blue;

    else if(!linktqStatus()->absoluteUrl().protocol().startsWith("http"))
        return TQt::darkGreen;

    else
    {
        TQString status_code(TQString::number(linktqStatus()->httpHeader().statusCode()));

        if(status_code[0] == '0')
        {
            kdWarning(23100) <<  "status code == 0: " << endl;
            kdWarning(23100) <<  linktqStatus()->toString() << endl;
            kdWarning(23100) <<  linktqStatus()->httpHeader().toString() << endl;
        }
        //Q_ASSERT(status_code[0] != '0');

        if(status_code[0] == '5')
            return TQt::darkMagenta;

        else if(status_code[0] == '4')
            return TQt::red;

        else if(status_code[0] == '3')
            return TQt::blue;

        else if(status_code[0] == '2')
            return TQt::darkGreen;

        else
            return TQt::red;
    }
}








