/***************************************************************************
 *   Copyright (C) 2004 by Paulo Moura Guedes                              *
 *   moura@kdewebdev.org                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

inline Node::Node()
        : is_redirection_(false), malformed_(false)
{}

inline Node::~Node()
{
    //kdDebug(23100) <<  "/";
}

inline Node::Node(TQString const& content)
        : content_(content), is_redirection_(false), malformed_(false)
{}

inline void Node::setNode(TQString const& content)
{
    content_ = content;
    parse();
}

inline TQString const& Node::content() const
{
    return content_;
}

inline bool Node::malformed() const
{
    return malformed_;
}

inline void Node::setMalformed(bool flag)
{
    malformed_ = flag;
}

inline Node::LinkType Node::linkType() const
{
    return linktype_;
}

inline Node::Element Node::element() const
{
    return element_;
}

inline void Node::setLinkType(Node::LinkType const& lt)
{
    linktype_ = lt;
}

inline bool Node::isRedirection() const
{
    return is_redirection_;
}

// class NodeLink_______________________________________________________

inline NodeLink::NodeLink()
        : Node()
{}

inline NodeLink::NodeLink(TQString const& content)
        : Node(content)
{
    parse();
}

inline void NodeLink::parse()
{
    parseAttributeHREF();
}

inline TQString const& NodeLink::url() const
{
    return attribute_href_;
}

inline TQString const& NodeLink::linkLabel() const
{
    return link_label_;
}

inline TQString NodeLink::mailto() const
{
    Q_ASSERT(linktype_ == Node::mailto);

    TQString href = KCharsets::resolveEntities(attribute_href_);

    int inicio = findWord(href, "MAILTO:");
    Q_ASSERT(inicio != -1);

    return href.mid(inicio);
}

inline bool NodeLink::isLink() const
{
    if(Node::linkType() != Node::mailto && !url().isEmpty())
        return true;
    else
        return false;
}

// class NodeA_______________________________________________________

inline NodeA::NodeA(TQString const& content)
        : NodeLink(content)
{
    element_ = A;
    parse();
}

inline TQString const& NodeA::attributeNAME() const
{
    return attribute_name_;
}

inline void NodeA::parse()
{
    parseAttributeNAME();
}

inline void NodeA::parseAttributeNAME()
{
    attribute_name_ = getAttribute("NAME=");
    //kdDebug(23100) << "NodeA::parseAttributeNAME: " << attribute_name_ << endl;
}

// class NodeAREA_______________________________________________________
        
inline NodeAREA::NodeAREA(TQString const& content)
    : NodeLink(content)
{
    element_ = AREA;
    parse();
}
            
inline TQString const& NodeAREA::attributeTITLE() const
{
    return attribute_title_;
}
                
inline void NodeAREA::parse()
{
    parseAttributeTITLE();
}
                    
inline void NodeAREA::parseAttributeTITLE()
{
    attribute_title_ = getAttribute("TITLE=");
//kdDebug(23100) << "NodeAREA::parseAttributeTITLE: " << attribute_title_ << endl;
}

// class NodeLINK________________________________________

inline NodeLINK::NodeLINK(TQString const& content)
        : NodeLink(content)
{
    element_ = LINK;
}

// class NodeMeta________________________________________

inline NodeMETA::NodeMETA()
    : Node()
{
    element_ = META;
}

inline NodeMETA::NodeMETA(TQString const& content)
        : Node(content)
{
    element_ = META;
    parse();
}

inline TQString const& NodeMETA::url() const
{
    return attribute_url_;
}

inline const TQString& NodeMETA::linkLabel() const
{
    return link_label_;
}

inline bool NodeMETA::isLink() const
{
    if(upperCase(attribute_http_equiv_) == "REFRESH" &&
            findWord(content(), "URL") != -1)
    {
        // Q_ASSERT(findWord(content(), "URL") != -1); // not necessarily
        return true;
    }
    else
        return false;
}

inline TQString const& NodeMETA::atributoHTTP_ETQUIV() const
{
    return attribute_http_equiv_;
}

inline TQString const& NodeMETA::atributoNAME() const
{
    return attribute_name_;
}

inline TQString const& NodeMETA::atributoCONTENT() const
{
    return attribute_content_;
}

inline bool NodeMETA::isRedirection() const
{
    return
        upperCase(attribute_http_equiv_) == "REFRESH";
}

inline void NodeMETA::parse()
{
    parseAttributeHTTP_ETQUIV();
    parseAttributeNAME();
    parseAttributeCONTENT();

    parseAttributeURL();
}

inline void NodeMETA::parseAttributeHTTP_ETQUIV()
{
    attribute_http_equiv_ = getAttribute("HTTP-ETQUIV=");
}

inline void NodeMETA::parseAttributeNAME()
{
    attribute_name_ = getAttribute("NAME=");
}

inline void NodeMETA::parseAttributeCONTENT()
{
    attribute_content_ = getAttribute("CONTENT=");
//     kdDebug(23100) << "CONTENT: " << attribute_content_ << endl;
}


// class NodeIMG________________________________________

inline NodeIMG::NodeIMG(TQString const& content)
        : Node(content)
{
    element_ = IMG;
    parse();
}

inline void NodeIMG::parse()
{
    parseAttributeSRC();
    parseAttributeTITLE();
    parseAttributeALT();
}

inline TQString const& NodeIMG::url() const
{
    return attribute_src_;
}

inline TQString const& NodeIMG::linkLabel() const
{
    if(!attribute_title_.isEmpty())
        return attribute_title_;
    else
        return attribute_alt_;
}

inline bool NodeIMG::isLink() const
{
    if(!url().isEmpty())
        return true;
    else
        return false;
}

inline void NodeIMG::parseAttributeTITLE()
{
    attribute_title_ = getAttribute("TITLE=");
}

inline void NodeIMG::parseAttributeALT()
{
    attribute_alt_ = getAttribute("ALT=");
}


// class NodeFRAME________________________________________

inline NodeFRAME::NodeFRAME(TQString const& content)
        : Node(content)
{
    element_ = FRAME;
    parse();
}

inline void NodeFRAME::parse()
{
    parseAttributeSRC();
}

inline TQString const& NodeFRAME::url() const
{
    return attribute_src_;
}

inline TQString const& NodeFRAME::linkLabel() const
{
    return link_label_;
}

inline bool NodeFRAME::isLink() const
{
    if(!url().isEmpty())
        return true;
    else
        return false;
}

// class NodeBASE________________________________________

inline NodeBASE::NodeBASE()
        : NodeLink()
{
    element_ = BASE;
}

inline NodeBASE::NodeBASE(TQString const& content)
        : NodeLink(content)
{
    element_ = BASE;
}

inline bool NodeBASE::isLink() const
{
    return false;
}

// class NodeTITLE________________________________________

inline NodeTITLE::NodeTITLE()
        : Node()
{
    element_ = TITLE;
    parse();
}

inline NodeTITLE::NodeTITLE(TQString const& content)
        : Node(content)
{
    element_ = TITLE;
    parse();
}

inline TQString const& NodeTITLE::url() const
{
    return TQString();
}

inline TQString const& NodeTITLE::linkLabel() const
{
    return TQString();
}

inline void NodeTITLE::parse()
{
    parseAttributeTITLE();
}

inline bool NodeTITLE::isLink() const
{
    return false;   
}

inline TQString const& NodeTITLE::attributeTITLE() const
{
    return attribute_title_;   
}

inline void NodeTITLE::parseAttributeTITLE()
{
    attribute_title_ = content_;
    attribute_title_.replace("<TITLE>", "", false);
    attribute_title_.replace("</TITLE>", "", false);
    attribute_title_.stripWhiteSpace();
    
    //kdDebug(23100) << "TITLE: " << attribute_title_ << endl;
}
