/***************************************************************************
 *   Copyright (C) 2004 by Paulo Moura Guedes                              *
 *   moura@kdewebdev.org                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

inline LinktqStatus::LinktqStatus()
        : status_(LinktqStatus::UNDETERMINED), depth_(-1), external_domain_depth_(-1), is_root_(false),
        error_occurred_(false), is_redirection_(false), parent_(0), redirection_(0), checked_(false),
        only_check_header_(true), malformed_(false),
        node_(0), has_base_URI_(false), has_html_doc_title_(false), ignored_(false),
        mimetype_(""), is_error_page_(false), tree_view_item_(0)
{}

inline LinktqStatus::LinktqStatus(KURL const& absolute_url)
        : status_(LinktqStatus::UNDETERMINED), depth_(-1), external_domain_depth_(-1), is_root_(false),
        error_occurred_(false), is_redirection_(false), parent_(0), redirection_(0), checked_(false),
        only_check_header_(true), malformed_(false),
        node_(0), has_base_URI_(false), has_html_doc_title_(false), ignored_(false),
        mimetype_(""), is_error_page_(false), tree_view_item_(0)
{
    setAbsoluteUrl(absolute_url);
}

inline LinktqStatus::LinktqStatus(Node* node, LinktqStatus* parent)
        : status_(LinktqStatus::UNDETERMINED), depth_(-1), external_domain_depth_(-1), is_root_(false),
        error_occurred_(false), is_redirection_(false), parent_(0), redirection_(0), checked_(false),
        only_check_header_(true), malformed_(false),
        node_(node), has_base_URI_(false), has_html_doc_title_(false), ignored_(false),
        mimetype_(""), is_error_page_(false), tree_view_item_(0)
{
    loadNode();

    setDepth(parent->depth() + 1);
    setParent(parent);
    setRootUrl(parent->rootUrl());
}

inline void LinktqStatus::setRootUrl(KURL const& url)
{
    root_url_ = url;
}

inline void LinktqStatus::settqStatus(tqStatus status)
{
    status_ = status;
}

inline void LinktqStatus::setDepth(uint depth)
{
    depth_ = depth;
}

inline void LinktqStatus::setParent(LinktqStatus* parent)
{
    Q_ASSERT(parent);

    parent_ = parent;
    addReferrer(parent->absoluteUrl());
}

inline void LinktqStatus::setAbsoluteUrl(KURL const& url_absoluto)
{
    absolute_url_ = url_absoluto;
}

inline void LinktqStatus::setOriginalUrl(TQString const& url_original)
{
    original_url_ = url_original;
}

inline void LinktqStatus::setLabel(TQString const& label)
{
    label_ = label;
}

inline void LinktqStatus::setDocHtml(TQString const& doc_html)
{
    Q_ASSERT(!doc_html.isEmpty());
    doc_html_ = doc_html;
}

inline void LinktqStatus::setHttpHeader(HttpResponseHeader const& cabecalho_http)
{
    http_header_ = cabecalho_http;
}

inline void LinktqStatus::setStatusText(TQString const& status)
{
    Q_ASSERT(!status.isEmpty());
    status_text_ = status;
}

inline void LinktqStatus::setError(TQString const& error)
{
    Q_ASSERT(!error.isEmpty());
    error_ = error;
}

inline void LinktqStatus::setErrorOccurred(bool houve_error)
{
    error_occurred_ = houve_error;
}

inline void LinktqStatus::setIsRoot(bool flag)
{
    is_root_ = flag;
    label_ = i18n("ROOT");
}

inline void LinktqStatus::setRedirection(LinktqStatus* redirection)
{
    Q_ASSERT(redirection != NULL);
    Q_ASSERT(isRedirection());
    redirection_ = redirection;
}

inline void LinktqStatus::setIsRedirection(bool e_redirection)
{
    is_redirection_ = e_redirection;
}

inline void LinktqStatus::addChildNode(Node* node)
{
    tqchildren_nodes_.push_back(node);
}

inline void LinktqStatus::reserveMemoryForChildrenNodes(int n)
{
    Q_ASSERT(n > 0);
    tqchildren_nodes_.reserve(n);
}

inline void LinktqStatus::setChecked(bool flag)
{
    checked_ = flag;
}

inline void LinktqStatus::setExternalDomainDepth(int p)
{
    Q_ASSERT(p >= -1);
    external_domain_depth_ = p;
}

inline void LinktqStatus::setOnlyCheckHeader(bool flag)
{
    only_check_header_= flag;
}

inline void LinktqStatus::setHasBaseURI(bool flag)
{
    has_base_URI_ = flag;
}

inline void LinktqStatus::setHasHtmlDocTitle(bool flag)
{
    has_html_doc_title_ = flag;
}

inline void LinktqStatus::setBaseURI(KURL const& base_url)
{
    if(!base_url.isValid())
    {
        kdWarning(23100) <<  "base url not valid: " << endl
        << "parent: " << parent()->absoluteUrl().prettyURL() << endl
        << "url: " << absoluteUrl().prettyURL() << endl
        << "base url resolved: " << base_url.prettyURL() << endl;
    }

    Q_ASSERT(base_url.isValid());
    has_base_URI_ = true;
    base_URI_ = base_url;
}

inline void LinktqStatus::setHtmlDocTitle(TQString const& title)
{
    if(title.isNull() || title.isEmpty())
    {
        kdError(23100) << "HTML doc title is null or empty!" << endl
        << toString() << endl;
    }
    Q_ASSERT(!title.isNull() && !title.isEmpty());

    has_html_doc_title_ = true;
    html_doc_title_ = title;
}

inline void LinktqStatus::setIgnored(bool flag)
{
    ignored_ = flag;
}

inline void LinktqStatus::setMimeType(TQString const& mimetype)
{
    Q_ASSERT(!mimetype.isNull() && !mimetype.isEmpty());
    mimetype_ = mimetype;
}

inline void LinktqStatus::setIsErrorPage(bool flag)
{
    is_error_page_ = flag;
}

inline void LinktqStatus::setIsLocalRestrict(bool flag)
{
    is_local_restrict_ = flag;
}

inline void LinktqStatus::setTreeViewItem(TreeViewItem* tree_view_item)
{
    Q_ASSERT(tree_view_item);
    tree_view_item_ = tree_view_item;
}

inline void LinktqStatus::addReferrer(KURL const& url)
{
    Q_ASSERT(url.isValid());

    referrers_.push_back(url);
}




inline KURL const& LinktqStatus::rootUrl() const
{
    return root_url_;
}

inline LinktqStatus::tqStatus const& LinktqStatus::status() const
{
    return status_;
}

inline uint LinktqStatus::depth() const
{
    return depth_;
}

inline bool LinktqStatus::local() const
{
    return external_domain_depth_ == -1;
}

inline bool LinktqStatus::isLocalRestrict() const
{
    return is_local_restrict_;
}

inline LinktqStatus const* LinktqStatus::parent() const
{
    return parent_;
}

inline TQString const& LinktqStatus::originalUrl() const
{
    return original_url_;
}

inline TQString const& LinktqStatus::label() const
{
    return label_;
}

inline KURL const& LinktqStatus::absoluteUrl() const
{
    return absolute_url_;
}

inline TQString const& LinktqStatus::docHtml() const
{
    return doc_html_;
}

inline HttpResponseHeader const& LinktqStatus::httpHeader() const
{
    return http_header_;
}

inline HttpResponseHeader& LinktqStatus::httpHeader()
{
    return http_header_;
}

inline TQString LinktqStatus::statusText() const
{
    if(errorOccurred())
        return error();
    else if(!absoluteUrl().protocol().startsWith("http"))
        return status_text_;
    else
    {
        TQString string_code = TQString::number(httpHeader().statusCode());
        if(absoluteUrl().hasRef()) // ref URL
            return status_text_;
        else if(string_code == "200"/* or string_code == "304"*/)
            return "OK";
        else
            return string_code;
    }
}

inline TQString const& LinktqStatus::error() const
{
    return error_;
}

inline bool LinktqStatus::isRoot() const
{
    return is_root_;
}

inline bool LinktqStatus::errorOccurred() const
{
    return error_occurred_;
}

inline bool LinktqStatus::isRedirection() const
{
    return is_redirection_;
}

inline LinktqStatus* LinktqStatus::redirection() const
{
    Q_ASSERT(isRedirection());
    
    return redirection_;
}

inline Node* LinktqStatus::node() const
{
    //Q_ASSERT(node_);
    return node_;
}

inline vector<Node*> const& LinktqStatus::tqchildrenNodes() const
{
    return tqchildren_nodes_;
}

inline bool LinktqStatus::checked() const
{
    return checked_;
}

inline int LinktqStatus::externalDomainDepth() const
{
    return external_domain_depth_;
}

inline bool LinktqStatus::onlyCheckHeader() const
{
    return only_check_header_;
}

inline bool LinktqStatus::hasBaseURI() const
{
    return has_base_URI_;
}

inline bool LinktqStatus::hasHtmlDocTitle() const
{
    return has_html_doc_title_;
}

inline KURL const& LinktqStatus::baseURI() const
{
    Q_ASSERT(hasBaseURI());
    return base_URI_;
}

inline TQString const& LinktqStatus::htmlDocTitle() const
{
    Q_ASSERT(has_html_doc_title_);
    return html_doc_title_;
}

inline bool LinktqStatus::ignored() const
{
    return ignored_;
}

inline TQString LinktqStatus::mimeType() const
{
    Q_ASSERT(!mimetype_.isNull());
    return mimetype_;
}

inline bool LinktqStatus::isErrorPage() const
{
    return is_error_page_;
}

inline TreeViewItem* LinktqStatus::treeViewItem() const
{
    return tree_view_item_;
}

inline TQValueVector<KURL> const& LinktqStatus::referrers() const
{
    return referrers_;
}

