/***************************************************************************
                          imagemap.h  -  description
                            -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef IMAGEMAP_H
#define IMAGEMAP_H

#include <tqscrollview.h>
#include <tqimage.h>
#include <tqpoint.h>
#include <tqrect.h>
#include <tqcursor.h>

#include "kdeversion.h"

class KImageMapEditor;
class Area;

/**
  *@short Draws the image and areas and handle the draw actions
  *@author Jan Sch&auml;fer
  *@internal
  *@see Area
  */
class DrawZone : public TQScrollView  {
public:

  DrawZone(TQWidget *parent,KImageMapEditor* _imageMapEditor);
  ~DrawZone();

  TQImage picture() const;
  void repaintArea(const Area & a);
  void repaintRect(const TQRect & r);
  void cancelDrawing();

  void setPicture(const TQImage &_image);
  void setZoom(double z);

  TQPoint translateFromZoom(const TQPoint & p) const;
  TQRect translateFromZoom(const TQRect & p) const;
  TQPoint translateToZoom(const TQPoint & p) const;
  TQRect translateToZoom(const TQRect & p) const;

  TQRect getImageRect() const { return image.rect(); }


protected:

  virtual void contentsMouseDoubleClickEvent(TQMouseEvent*);
  virtual void contentsMousePressEvent(TQMouseEvent*);
  virtual void contentsMouseReleaseEvent(TQMouseEvent*);
  virtual void contentsMouseMoveEvent(TQMouseEvent*);
  virtual void resizeEvent(TQResizeEvent*);
  virtual void drawContents(TQPainter*,int,int,int,int);
  virtual void viewportDropEvent(TQDropEvent*);
  virtual void contentsDragEnterEvent(TQDragEnterEvent*);
  virtual void contentsDropEvent(TQDropEvent*);
  
  /**
  * Represents whats currently going on
  * @li None : Nothing
  * @li DrawCircle : The user is drawing a circle
  * @li DrawRectangle : The user is drawing a rectangle
  * @li MoveSelectionPoint : The user is resizing an @ref Area or moving a polygon point
  * @li MoveArea : The user is moving an @ref Area
  * @li DoSelect : The user makes a selection rectangle
  */
  enum DrawAction { None, DrawCircle, DrawRectangle, DrawPolygon, DrawFreehand, MoveSelectionPoint, MoveArea, DoSelect, RemovePoint, AddPoint };

  void createBorderRectangles(const TQRect & r,TQRect & rb,TQRect & lb,TQRect & tb,TQRect & bb);

private:

  DrawAction currentAction;
  // The currently drawing area
  Area *currentArea;
  // Needed when moving selectionpoints
  TQRect *currentSelectionPoint;
  // The point where the user clicked the mouse
  TQPoint drawStart;
  TQPoint drawCurrent;
  // The original image
  TQImage image;
  KImageMapEditor *imageMapEditor;
  // Only the rect of the zoomed image, perhaps redundant
  TQRect imageRect;
  // Only for tqrepaint issues
  Area *oldArea;

  TQRect oldSelectionRect;
  // Holds the zoomed image for efficiency reasons
  TQPixmap zoomedImage;
  // The current zoom-factor
  double _zoom;

  TQCursor RectangleCursor;
  TQCursor CircleCursor;
  TQCursor PolygonCursor;
  TQCursor FreehandCursor;
  TQCursor AddPointCursor;
  TQCursor RemovePointCursor;
};

inline TQImage DrawZone::picture() const {
  return image;
}


#endif
