#include "settings.h"
#include "settings.moc"

#include <tqlabel.h>
#include <tqhbox.h>
#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqhgroupbox.h>

#include <klocale.h>
#include <knuminput.h>
#include <kcolorbutton.h>
#include <kapplication.h>
#include <kdialogbase.h>

#include "piece.h"
#include "factory.h"


//-----------------------------------------------------------------------------
BaseAppearanceConfig::BaseAppearanceConfig()
    : TQWidget(0, "appearance_config")
{
    TQVBoxLayout *top = new TQVBoxLayout(this);

    // upper part
    _main = new TQWidget(this);
    top->addWidget(_main);
    _grid = new TQGridLayout(_main, 3, 2, 0, KDialog::spacingHint());
    _grid->setColStretch(1, 1);

    TQCheckBox *chb =
        new TQCheckBox(i18n("Enable animations"), _main, "kcfg_AnimationsEnabled");
    _grid->addMultiCellWidget(chb, 2, 2, 0, 1);

    top->addSpacing(KDialog::spacingHint());

    // lower part
    TQHGroupBox *gbox = new TQHGroupBox(i18n("Background"), this);
    top->addWidget(gbox);
    TQWidget *widget = new TQWidget(gbox);
    TQGridLayout *grid =
        new TQGridLayout(widget, 2, 3, 0, KDialog::spacingHint());
    grid->setColStretch(2, 1);
    TQLabel *label = new TQLabel(i18n("Color:"), widget);
    grid->addWidget(label, 0, 0);
    KColorButton *cob = new KColorButton(widget, "kcfg_FadeColor");
    cob->setFixedWidth(100);
    grid->addWidget(cob, 0, 1);
    label = new TQLabel(i18n("Opacity:"), widget);
    grid->addWidget(label, 1, 0);
    KDoubleNumInput *dn = new KDoubleNumInput(widget, "kcfg_FadeIntensity");
    dn->setRange(0.0, 1.0, 0.01);
    grid->addMultiCellWidget(dn, 1, 1, 1, 2);

    top->addStretch(1);
}

//-----------------------------------------------------------------------------
ColorConfig::ColorConfig()
    : TQWidget(0, "color_config")
{
    const GPieceInfo &info = Piece::info();
    TQVBoxLayout *top = new TQVBoxLayout(this);
    uint nb = info.nbColors();
    TQGridLayout *grid = new TQGridLayout(top, nb+1, 3, KDialog::spacingHint());
    grid->setColStretch(2, 1);
    for (uint i=0; i<nb; i++) {
        TQLabel *label = new TQLabel(info.colorLabel(i), this);
        grid->addWidget(label, i, 0);
        KColorButton *cob = new KColorButton(this, colorKey(i));
        cob->setFixedWidth(100);
        grid->addWidget(cob, i, 1);
    }
    grid->setRowStretch(nb, 1);
}

TQCString ColorConfig::colorKey(uint i)
{
    TQCString s;
    s.setNum(i);
    return "kcfg_Color" + s;
}

