#include "gamestatsimpl.h"
#include "dealer.h"
#include "version.h"

#include <tqcombobox.h>
#include <tqlabel.h>

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>

GameStatsImpl::GameStatsImpl(TQWidget* aParent, const char* aname)
	: GameStats(aParent, aname)
{
	TQStringList list;
	TQValueList<DealerInfo*>::ConstIterator it;
	for (it = DealerInfoList::self()->games().begin();
			it != DealerInfoList::self()->games().end(); ++it)
	{
		// while we develop, it may happen that some lower
		// indices do not exist
		uint index = (*it)->gameindex;
		for (uint i = 0; i <= index; i++)
			if (list.count() <= i)
				list.append("unknown");
		list[index] = i18n((*it)->name);
		list[index].replace('&',"");
	}
	GameType->insertStringList(list);
	showGameType(0);
}

void GameStatsImpl::showGameType(int id)
{
	GameType->setCurrentItem(id);
	setGameType(id);
}

void GameStatsImpl::setGameType(int id)
{
	// Trick to reset string to original value
	languageChange();
	KConfig *config = kapp->config();
	KConfigGroupSaver kcs(config, scores_group);
	unsigned int t = config->readUnsignedNumEntry(TQString("total%1").tqarg(id),0);
	Played->setText(Played->text().tqarg(t));
	unsigned int w = config->readUnsignedNumEntry(TQString("won%1").tqarg(id),0);
	Won->setText(Won->text().tqarg(w));
	if (t)
		WonPerc->setText(WonPerc->text().tqarg(w*100/t));
	else
		WonPerc->setText(WonPerc->text().tqarg(0));
	WinStreak->setText(
		WinStreak->text().tqarg(config->readUnsignedNumEntry(TQString("maxwinstreak%1").tqarg(id),0)));
	LooseStreak->setText(
		LooseStreak->text().tqarg(config->readUnsignedNumEntry(TQString("maxloosestreak%1").tqarg(id),0)));
}
