#include <tqlayout.h>
#include <kapplication.h>
#include <klocale.h>
#include <math.h>
#include <kglobal.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "fleetdlg.h"

FleetDlgListViewItem::FleetDlgListViewItem(TQListView *parent, TQString s1, TQString s2, TQString s3, TQString s4, TQString s5) : TQListViewItem(parent, s1, s2, s3, s4, s5)
{
}

int FleetDlgListViewItem::compare(TQListViewItem *i, int col, bool) const
{
	if (col == 1)
	{
		if (text(col) > i -> text(col)) return 1;
		else if (text(col) < i -> text(col)) return -1;
		else return compare(i, 0, true);
	}
	else if (col == 3)
	{
		if (text(col).toDouble() > i -> text(col).toDouble()) return 1;
		else if (text(col).toDouble() < i -> text(col).toDouble()) return -1;
		else return compare(i, 0, true);
	}
	else
	{
		if (text(col).toInt() > i -> text(col).toInt()) return 1;
		else if (text(col).toInt() < i -> text(col).toInt()) return -1;
		else return compare(i, 0, true);
	}
}


FleetDlg::FleetDlg( TQWidget *parent, AttackFleetList *fleets )
    : TQDialog(parent, "FleetDlg", true ), fleetList(fleets)
{
    setCaption( kapp->makeStdCaption(i18n("Fleet Overview")) );

    fleetTable = new KListView( this, 0 );
    fleetTable->addColumn(i18n("Fleet No."));
    fleetTable->addColumn(i18n("Destination"));
    fleetTable->addColumn(i18n("Ships"));
    fleetTable->addColumn(i18n("Kill Percentage"));
    fleetTable->addColumn(i18n("Arrival Turn"));
    fleetTable->setMinimumSize( fleetTable->tqsizeHint() );

    KPushButton *okButton = new KPushButton( KStdGuiItem::ok(), this );
    okButton->setMinimumSize( okButton->tqsizeHint() );
    okButton->setDefault(true);

    TQVBoxLayout *tqlayout1 = new TQVBoxLayout( this );
    TQHBoxLayout *tqlayout2 = new TQHBoxLayout;

    tqlayout1->addWidget( fleetTable, 1 );
    tqlayout1->addLayout( tqlayout2 );

    tqlayout2->addStretch( 2 );
    tqlayout2->addWidget( okButton );
    tqlayout2->addStretch( 2 );

    connect( okButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()) );

    init();

    resize( 580, 140  );
}

void
FleetDlg::init()
{
    AttackFleet *curFleet;
    AttackFleetListIterator nextFleet( *fleetList );
    int fleetNumber = 0;
    
    while( (curFleet = nextFleet())) {
        fleetNumber++;
        new FleetDlgListViewItem(fleetTable,
                                 TQString("%1").tqarg(fleetNumber),
                                 curFleet->destination->getName(),
                                 TQString("%1").tqarg(curFleet->getShipCount()),
                                 TQString("%1").tqarg(KGlobal::locale()->formatNumber(curFleet->killPercentage, 3)),
                                 TQString("%1").tqarg((int)ceil(curFleet->arrivalTurn)));
    }
}
