#include <tqcanvas.h>

#include <kconfig.h>

#include "game.h"
#include "canvasitem.h"

TQCanvasRectangle *CanvasItem::onVStrut()
{
	TQCanvasItem *qthis = dynamic_cast<TQCanvasItem *>(this);
	if (!qthis)
		return 0;
	TQCanvasItemList l = qthis->collisions(true);
	l.sort();
	bool aboveVStrut = false;
	CanvasItem *item = 0;
	TQCanvasItem *qitem = 0;
	for (TQCanvasItemList::Iterator it = l.begin(); it != l.end(); ++it)
	{
		item = dynamic_cast<CanvasItem *>(*it);
		if (item)
		{
			qitem = *it;
			if (item->vStrut())
			{
				//kdDebug(12007) << "above vstrut\n";
				aboveVStrut = true;
				break;
			}
		}
	}

	TQCanvasRectangle *ritem = dynamic_cast<TQCanvasRectangle *>(qitem);

	return aboveVStrut && ritem? ritem : 0;
}

void CanvasItem::save(KConfig *cfg)
{
	cfg->writeEntry("dummykey", true);
}

void CanvasItem::playSound(TQString file, double vol)
{
	if (game)
		game->playSound(file, vol);
}

