#include "piece.h"

#include <tqpainter.h>
#include <klocale.h>
#include "base/board.h"


const char *KLPieceInfo::DEFAULT_COLORS[NB_BLOCK_TYPES] = {
    "#C86464", "#64C864", "#6464C8", "#C8C864", "#C864C8"
};

TQColor KLPieceInfo::defaultColor(uint i) const
{
  if ( i>=nbColors() ) return TQColor();
  return TQColor(DEFAULT_COLORS[i]);
}

TQString KLPieceInfo::colorLabel(uint i) const
{
    return i18n("Color #%1:").tqarg(i+1);
}

void KLPieceInfo::draw(TQPixmap *pixmap, uint blockType, uint bMode,
                       bool lighted) const
{
	TQColor col = color(blockType);
    if (lighted) col = col.light();
    pixmap->fill(col);

	TQPainter p(pixmap);
    TQRect r = pixmap->rect();

    p.setPen(col.dark());
    if ( !(bMode & BaseBoard::Up) )
        p.drawLine(r.topLeft(), r.topRight());
    if ( !(bMode & BaseBoard::Down) )
        p.drawLine(r.bottomLeft(), r.bottomRight());
    if ( !(bMode & BaseBoard::Left) )
        p.drawLine(r.topLeft(), r.bottomLeft());
    if ( !(bMode & BaseBoard::Right) )
        p.drawLine(r.topRight(),r.bottomRight());

    p.setPen(col.dark(110));
    if (bMode & BaseBoard::Up)
        p.drawLine(r.topLeft()+TQPoint(1,0), r.topRight()+TQPoint(-1,0));
    if (bMode & BaseBoard::Down)
        p.drawLine(r.bottomLeft()+TQPoint(1,0), r.bottomRight()+TQPoint(-1,0));
    if (bMode & BaseBoard::Left)
        p.drawLine(r.topLeft()+TQPoint(0,1), r.bottomLeft()+TQPoint(0,-1));
    if (bMode & BaseBoard::Right)
        p.drawLine(r.topRight()+TQPoint(0,1), r.bottomRight()+TQPoint(0,-1));
}
