/* configbox.cpp
 *
 * 1999 (c) Cristian Tibirna (tibirna@kde.org)
 *
 */

#include "configbox.h"
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqslider.h>

#include "settings.h"

extern Options settings;

ConfigBox::ConfigBox ( TQWidget *parent, const char *name)
    : KDialogBase ( parent, name, true, i18n("Configure"), Ok | Cancel, Ok, true )
{
  TQWidget *page = makeMainWidget();  

  TQGridLayout *glay = new TQGridLayout (page, 4, 5, 0, spacingHint());
  glay->setRowStretch(0, 1);
  glay->setRowStretch(3, 1);
  glay->setColStretch(0, 1);
  glay->setColStretch(4, 1);
 
  glay->addWidget(new TQLabel(i18n("Animation speed:"),page), 2, 1);

  disp = new TQLCDNumber(page);
  glay->addWidget(disp, 1, 2);
  disp->display(1);

  speed = new TQSlider(1, 10, 1, 1, Qt::Horizontal, page);
  glay->addMultiCellWidget(speed, 2, 2, 2, 3);

  connect(speed, TQT_SIGNAL(valueChanged(int)), disp, TQT_SLOT(display(int)));

  speed->setValue(settings.anim_speed);
  incInitialSize(TQSize(20,20), true);
}
  
void ConfigBox::slotOk()
{
  settings.anim_speed = speed->value();
  settings.changed = true;

  emit speedChanged();

  accept();
}

ConfigBox::~ConfigBox()
{
}

#include "configbox.moc" 
