/* InputBox.cpp
**
** Copyright (C) 2000,2001 by Bernhard Rosenkraenzer
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include "InputBox.moc"
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqwhatsthis.h>
#include <ui.h>

InputBox::InputBox(entries e, TQWidget *parent, const char *name, bool hasCancel, WFlags f):TQDialog(parent, name, true, f)
{
	TQVBoxLayout *tqlayout=new TQVBoxLayout(this);
	tqlayout->setMargin(SPACE_MARGIN);
	tqlayout->setSpacing(SPACE_INSIDE);
	for(entries::iterator it=e.begin(); it!=e.end(); it++) {
		EditWidget *ed=new EditWidget((*it).label, (*it).dflt, (*it).isFile, this);
		TQWhatsThis::add(ed, (*it).help);
		tqlayout->addWidget(ed);
		edit.insert(edit.end(), ed);
	}
	if(hasCancel) {
		TQHBox *btns=new TQHBox(this);
		ok=new TQPushButton(_("&OK"), btns);
		cancel=new TQPushButton(_("&Cancel"), btns);
		tqlayout->addWidget(btns);
		connect(cancel, TQT_SIGNAL(clicked()), TQT_SLOT(reject()));
	} else {
		ok=new TQPushButton(_("&OK"), this);
		tqlayout->addWidget(ok);
	}
	connect(ok, TQT_SIGNAL(clicked()), TQT_SLOT(accept()));
}
