// (c) 2000 Peter Putzer

#ifndef KSVDRAG_H
#define KSVDRAG_H

#include <tqdragobject.h>

class KSVData;
class KSVItem;
class TQWidget;

class KSVDrag : public TQDragObject
{
  Q_OBJECT
  TQ_OBJECT

public:
  KSVDrag (const KSVData& item, TQWidget* dragSource = 0L, const char* name = 0L);
  KSVDrag (const KSVItem& item, TQWidget* dragSource = 0L, const char* name = 0L);
  virtual ~KSVDrag();

  virtual const char* format (int i) const;
  TQByteArray tqencodedData (const char*) const;
  
  static bool decodeNative (const TQMimeSource*, KSVData&);
  
private:
  enum
  {
	Native, Text, URL
  };

  class Private;
  Private* d;
};

#endif // KSVDRAG_H
