// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#include <time.h>

#include <tqdatetime.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqfile.h>

#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>

#include "FileInfoWidget.h"
#include "Util.h"

#include "FileInfoWidget.moc"

FileInfoWidget::FileInfoWidget( TQWidget* parent, const char* name )
        : TQWidget( parent, name )
{
    TQLabel* lbl1 = new TQLabel( i18n( "File name:" ), this );
    TQLabel* lbl2 = new TQLabel( i18n( "Created on:" ), this );
    TQLabel* lbl3 = new TQLabel( i18n( "Last modified:" ), this );
    TQLabel* lbl4 = new TQLabel( i18n( "Last accessed:" ), this );
    TQLabel* lbl5 = new TQLabel( i18n( "Size:" ), this );
    TQLabel* lbl6 = new TQLabel( i18n( "Owner:" ), this );
    TQLabel* lbl7 = new TQLabel( i18n( "Group:" ), this );

    int max = lbl1->tqsizeHint().width();
    if ( lbl2->tqsizeHint().width() > max ) max = lbl2->tqsizeHint().width();
    if ( lbl3->tqsizeHint().width() > max ) max = lbl3->tqsizeHint().width();
    if ( lbl4->tqsizeHint().width() > max ) max = lbl4->tqsizeHint().width();
    if ( lbl5->tqsizeHint().width() > max ) max = lbl5->tqsizeHint().width();
    if ( lbl6->tqsizeHint().width() > max ) max = lbl6->tqsizeHint().width();
    if ( lbl7->tqsizeHint().width() > max ) max = lbl7->tqsizeHint().width();

    lbl1->setFixedSize( max, lbl1->tqsizeHint().height() );
    lbl2->setFixedSize( max, lbl2->tqsizeHint().height() );
    lbl3->setFixedSize( max, lbl3->tqsizeHint().height() );
    lbl4->setFixedSize( max, lbl4->tqsizeHint().height() );
    lbl5->setFixedSize( max, lbl5->tqsizeHint().height() );
    lbl6->setFixedSize( max, lbl6->tqsizeHint().height() );
    lbl7->setFixedSize( max, lbl7->tqsizeHint().height() );

    _fileName = new TQLabel( "???", this );
    _fileName->setFixedHeight( _fileName->tqsizeHint().height() );
    
    _ctime = new TQLabel( "???", this );
    _ctime->setFixedHeight( _ctime->tqsizeHint().height() );

    _mtime = new TQLabel( "???", this );
    _mtime->setFixedHeight( _mtime->tqsizeHint().height() );
    
    _atime = new TQLabel( "???", this );
    _atime->setFixedHeight( _atime->tqsizeHint().height() );

    _size = new TQLabel( "???", this );
    _size->setFixedHeight( _size->tqsizeHint().height() );

    _owner = new TQLabel( "???", this );
    _owner->setFixedHeight( _owner->tqsizeHint().height() );

    _group = new TQLabel( "???", this );
    _group->setFixedHeight( _group->tqsizeHint().height() );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 4, 4 );

    TQHBoxLayout* l1_1 = new TQHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addWidget( lbl1 );
    l1_1->addWidget( _fileName, 1 );

    TQHBoxLayout* l1_2 = new TQHBoxLayout();
    l1->addLayout( l1_2 );
    l1_2->addWidget( lbl2 );
    l1_2->addWidget( _ctime, 1 );

    TQHBoxLayout* l1_3 = new TQHBoxLayout();
    l1->addLayout( l1_3 );
    l1_3->addWidget( lbl3 );
    l1_3->addWidget( _mtime, 1 );

    TQHBoxLayout* l1_4 = new TQHBoxLayout();
    l1->addLayout( l1_4 );
    l1_4->addWidget( lbl4 );
    l1_4->addWidget( _atime, 1 );

    TQHBoxLayout* l1_5 = new TQHBoxLayout();
    l1->addLayout( l1_5 );
    l1_5->addWidget( lbl5 );
    l1_5->addWidget( _size, 1 );

    TQHBoxLayout* l1_6 = new TQHBoxLayout();
    l1->addLayout( l1_6 );
    l1_6->addWidget( lbl6 );
    l1_6->addWidget( _owner, 1 );

    TQHBoxLayout* l1_7 = new TQHBoxLayout();
    l1->addLayout( l1_7 );
    l1_7->addWidget( lbl7 );
    l1_7->addWidget( _group, 1 );

    l1->addStretch( 1 );
}

FileInfoWidget::~FileInfoWidget()
{
}

void FileInfoWidget::setFile( const TQString & name )
{
    if ( name.isNull() ) {
        return;
    }

    _fileName->setText( name );

    struct stat info;
    lstat( TQFile::encodeName(name), &info );

    TQString tmp;
    TQDateTime datetime;

    datetime.setTime_t(info.st_ctime);
    _ctime->setText( KGlobal::locale()->formatDateTime(datetime, false) );

    datetime.setTime_t(info.st_mtime);
    _mtime->setText( KGlobal::locale()->formatDateTime(datetime, false) );

    datetime.setTime_t(info.st_atime);
    _atime->setText( KGlobal::locale()->formatDateTime(datetime, false) );
    
    _size->setText( Util::bytesToString( info.st_size ) );

    struct passwd* p;
    p = getpwuid( info.st_uid );
    if ( p ) {
        tmp = p->pw_name;
    } else {
        tmp.setNum( info.st_uid );
    }
    _owner->setText( tmp );

    struct group* g;
    g = getgrgid( info.st_gid );
    if ( g ) {
        tmp = g->gr_name;
    } else {
        tmp.setNum( info.st_gid );
    }
    _group->setText( tmp );
}
