/* ============================================================
 * File  : sink.cpp
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2007-01-22
 *
 * Copyright 2007 Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#include "sink.h"
#include "sinkfactory.h"
#include "libkipi2/collection.h"

namespace KIPISyncPlugin
{

Sink::Sink(unsigned int sinkId, TQString name, KConfig*, KWallet::Wallet*)
 : mSinkId(sinkId),
   mName(name)
{
}

unsigned int Sink::SinkId()
{
  return mSinkId;
}

TQString Sink::Name()
{
  return mName;
}
/*
Sink::Sink(const TQString& name, const TQString& url,
           const TQString& username, const TQString& password,
           const unsigned int version,
           const unsigned int sinkId)
  : mName(name),
    mUrl(url),
    mUsername(username),
    mPassword(password),
    mVersion(version),
    mSinkId(sinkId)
{

}

Sink::~Sink()
{

}

TQString Sink::name() const { return mName; }
TQString Sink::url() const { return mUrl; }
TQString Sink::username() const { return mUsername; }
TQString Sink::password() const { return mPassword; }
unsigned int Sink::version() const { return mVersion; }
unsigned int Sink::sinkId() const { return mSinkId; }

void Sink::setName(TQString name) { mName = name; }
void Sink::setUrl(TQString url) { mUrl = url; }
void Sink::setUsername(TQString username) { mUsername = username; }
void Sink::setPassword(TQString password) { mPassword = password; }
void Sink::setVersion(unsigned int version) { mVersion = version; }
void Sink::setSinkId(unsigned int sinkId) { mSinkId = sinkId; }


void Sink::asTQListViewItem(TQListView* pParent)
{
  new SinkTQListViewItem(this, pParent);
}
*/

// Pretend sink (just for testin the structure - will be removed!)
Sink2::Sink2(unsigned int sinkId, TQString name, KConfig* pConfig, KWallet::Wallet* pWallet)
 : Sink(sinkId, name, pConfig, pWallet)
{
  mName = "Sink2";
}

TQString Sink2::Type() { return "Sink2"; }
TQString Sink2::TypeDescription() { return "Sink2"; }

KIPI2::CollectionList* Sink2::getCollections()
{
  //KIPI2::Collection* tmp = new KIPI2::Collection;
  return (KIPI2::CollectionList*) NULL;
}

void Sink2::Save(KConfig*, KWallet::Wallet*)
{
  
}

void test()
{
  SinkFactory::Register("Sink2", SinkCreator<Sink2>);
  
  Sink* p_tmp = SinkFactory::Create("Sink2", 1, "Something", NULL, NULL);
  p_tmp = p_tmp;
}
}

//#include "sink.moc"
