/* ============================================================
 * File  : gallerywidget.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-01
 * Description :
 *
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <klocale.h>
#include <khtml_part.h>
#include <khtmlview.h>

#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqheader.h>
#include <tqlistview.h>
#include <tqbuttongroup.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqsplitter.h>
#include <tqwhatsthis.h>

#include "gallerywidget.h"

namespace KIPIGalleryExportPlugin
{

GalleryWidget::GalleryWidget( TQWidget* parent, const char* name, WFlags fl )
    : TQWidget( parent, name, fl )
{
    if ( !name )
	      setName( "GalleryWidget" );
    TQVBoxLayout*  galleryWidgetLayout
        = new TQVBoxLayout( this, 5, 5, "GalleryWidgetLayout");

    // ------------------------------------------------------------------------

    TQLabel*       headerLabel;
    TQFrame*       headerLine;

    headerLabel = new TQLabel( this, "headerLabel" );
    galleryWidgetLayout->addWidget( headerLabel, 0 );
    headerLine = new TQFrame( this, "headerLine" );
    headerLine->setFrameShape( TQFrame::HLine );
    headerLine->setFrameShadow( TQFrame::Sunken );
    galleryWidgetLayout->addWidget( headerLine, 0 );

    // ------------------------------------------------------------------------

    TQSplitter* splitter = new TQSplitter(this);
    galleryWidgetLayout->addWidget( splitter, 5 );

    m_albumView = new TQListView( splitter, "m_albumView" );
    m_albumView->addColumn( i18n( "Albums" ) );
    m_albumView->setResizeMode( TQListView::AllColumns );

    // ------------------------------------------------------------------------

    m_photoView = new KHTMLPart( splitter, "m_photoView" );

    // ------------------------------------------------------------------------

    TQVBoxLayout*  rightButtonGroupLayout;
    TQSpacerItem*  spacer;
    TQButtonGroup* rightButtonGroup;

    rightButtonGroup = new TQButtonGroup( splitter, "rightButtonGroup" );
    rightButtonGroupLayout = new TQVBoxLayout( rightButtonGroup );
    rightButtonGroupLayout->setSpacing( 5 );
    rightButtonGroupLayout->setMargin( 5 );

    m_newAlbumBtn = new TQPushButton( rightButtonGroup, "m_newAlbumBtn" );
    m_newAlbumBtn->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    rightButtonGroupLayout->addWidget( m_newAlbumBtn, 0, TQt::AlignHCenter );

    m_addPhotoBtn = new TQPushButton( rightButtonGroup, "m_addPhotoBtn" );
    m_addPhotoBtn->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    rightButtonGroupLayout->addWidget( m_addPhotoBtn, 0, TQt::AlignHCenter );

    // ------------------------------------------------------------------------

    TQGroupBox* optionsBox = new TQGroupBox(i18n("Override Default Options"),
                                          rightButtonGroup);
    optionsBox->setColumnLayout(0, Qt::Vertical);
    optionsBox->layout()->setSpacing(5);
    optionsBox->layout()->setMargin(5);
    TQGridLayout* optionsBoxLayout = new TQGridLayout(optionsBox->layout());

    // ------------------------------------------------------------------------

    m_resizeCheckBox = new TQCheckBox(optionsBox);
    m_resizeCheckBox->setText(i18n("Resize photos before uploading"));
    optionsBoxLayout->addMultiCellWidget(m_resizeCheckBox, 0, 0, 0, 1);

    m_dimensionSpinBox  = new TQSpinBox(0, 5000, 10, optionsBox);
    m_dimensionSpinBox->setValue(600);
    m_dimensionSpinBox->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    optionsBoxLayout->addWidget(m_dimensionSpinBox, 1, 1);

    TQLabel* resizeLabel = new TQLabel(i18n("Maximum dimension:"), optionsBox);
    optionsBoxLayout->addWidget(resizeLabel, 1, 0);

    m_resizeCheckBox->setChecked(false);
    m_dimensionSpinBox->setEnabled(false);
    connect(m_resizeCheckBox, TQT_SIGNAL(clicked()), TQT_SLOT(slotResizeChecked()));

    // ------------------------------------------------------------------------

    rightButtonGroupLayout->addWidget(optionsBox);

    // ------------------------------------------------------------------------

    spacer = new TQSpacerItem( 20, 100, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    rightButtonGroupLayout->addItem( spacer );

    // ------------------------------------------------------------------------

    headerLabel->setText( i18n( "<h2>Gallery Export</h2>" ) );
    m_albumView->header()->setLabel( 0, i18n( "Albums" ) );
    m_newAlbumBtn->setText( i18n( "&New Album" ) );
    m_addPhotoBtn->setText( i18n( "&Add Photos" ) );

    // ------------------------------------------------------------------------

    resize( TQSize(600, 400).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

GalleryWidget::~GalleryWidget()
{
}

void GalleryWidget::slotResizeChecked()
{
    m_dimensionSpinBox->setEnabled(m_resizeCheckBox->isChecked());
}

}

#include "gallerywidget.moc"
