/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-05
 * Description : a kipi plugin to slide images.
 *
 * Copyright (C) 2006-2007 by Valerio Fuoglio <valerio dot fuoglio at gmail dot com>
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqtoolbutton.h>
#include <tqlayout.h>
#include <tqpixmap.h>

// KDE includes.

#include <kapplication.h>
#include <kiconloader.h>
#include <klocale.h>

// Local includes.

#include "toolbar.h"
#include "toolbar.moc"

namespace KIPISlideShowPlugin
{

ToolBar::ToolBar(TQWidget* parent)
       : TQWidget(parent)
{
    TQHBoxLayout* lay = new TQHBoxLayout(this);
    m_playBtn = new TQToolButton(this);
    m_prevBtn = new TQToolButton(this);
    m_nextBtn = new TQToolButton(this);
    m_stopBtn = new TQToolButton(this);
    m_playBtn->setToggleButton(true);

    KIconLoader* loader = kapp->iconLoader();
    m_playBtn->setIconSet(loader->loadIcon("player_pause", KIcon::NoGroup, 22));
    m_prevBtn->setIconSet(loader->loadIcon("back", KIcon::NoGroup, 22));
    m_nextBtn->setIconSet(loader->loadIcon("forward", KIcon::NoGroup, 22));
    m_stopBtn->setIconSet(loader->loadIcon("stop", KIcon::NoGroup, 22));

    lay->addWidget(m_playBtn);
    lay->addWidget(m_prevBtn);
    lay->addWidget(m_nextBtn);
    lay->addWidget(m_stopBtn);

    adjustSize();
    setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);

    m_canHide = true;
    
    connect(m_playBtn, TQT_SIGNAL(toggled(bool)),
            this, TQT_SLOT(slotPlayBtnToggled()));
	    
    connect(m_nextBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotNexPrevClicked()));
	    
    connect(m_prevBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotNexPrevClicked()));

    connect(m_nextBtn, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalNext()));
	    
    connect(m_prevBtn, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalPrev()));
	    
    connect(m_stopBtn, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalClose()));
}

ToolBar::~ToolBar()
{    
}

bool ToolBar::canHide() const
{
    return m_canHide;    
}

bool ToolBar::isPaused() const
{
    return m_playBtn->isOn();
}

void ToolBar::setPaused(bool val)
{
    if (val == isPaused())
        return;

    m_playBtn->setOn(val);
    slotPlayBtnToggled();
}

void ToolBar::setEnabledPlay(bool val)
{
    m_playBtn->setEnabled(val);    
}

void ToolBar::setEnabledNext(bool val)
{
    m_nextBtn->setEnabled(val);    
}

void ToolBar::setEnabledPrev(bool val)
{
    m_prevBtn->setEnabled(val);    
}

void ToolBar::slotPlayBtnToggled()
{
    if (m_playBtn->isOn())
    {
        m_canHide = false;
        KIconLoader* loader = kapp->iconLoader();
        m_playBtn->setIconSet(loader->loadIcon("player_play", KIcon::NoGroup, 22));
        emit signalPause();
    }
    else
    {
        m_canHide = true;
        KIconLoader* loader = kapp->iconLoader();
        m_playBtn->setIconSet(loader->loadIcon("player_pause", KIcon::NoGroup, 22));
        emit signalPlay();
    }
}

void ToolBar::slotNexPrevClicked()
{
    if (!m_playBtn->isOn())
    {
        m_playBtn->setOn(true);
        m_canHide = false;
        KIconLoader* loader = kapp->iconLoader();
        m_playBtn->setIconSet(loader->loadIcon("player_play", KIcon::NoGroup, 22));
        emit signalPause();
    }
}

void ToolBar::keyPressEvent(TQKeyEvent *event)
{
    switch(event->key())
    {
    case(TQt::Key_Space):
    {
        if (m_playBtn->isEnabled())
            m_playBtn->animateClick();
        break;
    }
    case(TQt::Key_Prior):
    {
        if (m_prevBtn->isEnabled())
            m_prevBtn->animateClick();
        break;
    }
    case(TQt::Key_Next):
    {
        if (m_nextBtn->isEnabled())
            m_nextBtn->animateClick();
        break;
    }
    case(TQt::Key_Escape):
    {
        if (m_stopBtn->isEnabled())
            m_stopBtn->animateClick();
        break;
    }
    default:
        break;
    }

    event->accept();
}

} // namespace KIPISlideShowPlugin
