/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2007-16-07
 * Description : a kipi plugin to export images to Picasa web service
 *
 * Copyright (C) 2007-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef PICASAWEBTALKER_H
#define PICASAWEBTALKER_H

// TQt includes.

#include <tqvaluelist.h>
#include <tqobject.h>
#include <tqprogressdialog.h>
#include <tqmap.h>

// KDE includes.

#include <kurl.h>
#include <kio/jobclasses.h>

namespace KIO
{
    class Job;
}

class KURL;

namespace KIPIPicasawebExportPlugin
{

class GAlbum;
class GPhoto;
class FPhotoInfo;
class PicasaWebAlbum;

class PicasawebTalker : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:

    enum State 
    {
        FE_LOGIN = 0,
        FE_LISTALBUMS,
        FE_ADDTAG,
        FE_LISTPHOTOS,
        FE_GETPHOTOPROPERTY,
        FE_ADDPHOTO,
        FE_GETFROB,
        FE_CHECKTOKEN,
        FE_GETTOKEN,
        FE_CREATEALBUM,
        FE_GETAUTHORIZED
    };

public:

    PicasawebTalker(TQWidget* parent);
    ~PicasawebTalker();

    TQValueList <PicasaWebAlbum> * m_albumsList;
    TQString getApiSig(TQString,TQStringList) ;
    void addPhotoTag(const TQString& photoURI, const TQString& tag);   
    void getToken(const TQString& user, const TQString& passwd) ;	   
    void checkToken(const TQString& token) ;	   
    void authenticate(const TQString& token=NULL, const TQString& username=NULL, const TQString& password=NULL) ;	   
    void getPhotoProperty(const TQString& method, const TQString& argList) ;	   
    void getHTMLResponseCode(const TQString& str);   
    void listAllAlbums();
    void listPhotos( const TQString& albumName );
    void createAlbum( const TQString& albumTitle, const TQString& albumDesc, const TQString& location,
                      uint timestamp, const TQString& access, const TQString& media_keywords, bool isCommentEnabled=true);
    bool addPhoto( const TQString& photoPath,
                   FPhotoInfo& info, const TQString& albumname,
			       bool rescale=false, int maxDim=600 , int imageQuality=85 );
	TQString getUserName();
	TQString getUserId();
    void cancel();

public:
    
    TQProgressDialog *authProgressDlg;

signals:

    void signalError( const TQString& msg );
//  void signalLoginFailed( const TQString& msg );
    void signalBusy( bool val );
    void signalAlbums( const TQValueList<GAlbum>& albumList );
    void signalPhotos( const TQValueList<GPhoto>& photoList );
    void signalAddPhotoSucceeded( );
    void signalGetAlbumsListSucceeded();
    void signalGetAlbumsListFailed( const TQString& msg );
    void signalAddPhotoFailed( const TQString& msg );
    void signalAuthenticate() ;     
    void signalTokenObtained(const TQString& token);

private:

//  void parseResponseLogin(const TQByteArray &data);
    void parseResponseListAlbums(const TQByteArray &data);
    void parseResponseListPhotos(const TQByteArray &data);
    void parseResponseCreateAlbum(const TQByteArray &data);
    void parseResponseAddPhoto(const TQByteArray &data);
    void parseResponseAddTag(const TQByteArray &data);
    void parseResponseGetToken(const TQByteArray &data);
    void parseResponseCheckToken(const TQByteArray &data);
    void parseResponsePhotoProperty(const TQByteArray &data);
   	
private slots:

    void slotError( const TQString& msg );
//  void slotAuthenticate() ;	    
    void data(KIO::Job *job, const TQByteArray &data);
    void info(KIO::Job *job, const TQString& str);
    void slotResult (KIO::Job *job);

private:

    int        remaining_tags_count;

    TQWidget*   m_parent;

    TQByteArray m_buffer;

//  TQString    m_cookie;
    TQString    m_apikey;
    TQString    m_secret;
    TQString    m_frob;
    TQString    m_token;
    TQString    m_username;
    TQString    m_password;
    TQString    m_userId;

    TQMap<TQString, TQStringList > tags_map;

//  KURL       m_url;
    KIO::Job*  m_job;

    State      m_state;

};

} // namespace KIPIPicasawebExportPlugin

#endif /* PICASAWEBTALKER_H */
