/* ============================================================
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef SAVEFILEDIALOG_H
#define SAVEFILEDIALOG_H

#include <tqdialog.h>

class TQString;
class TQLineEdit;
class TQPushButton;

namespace KIPIKameraKlientPlugin
{

class SavefileDialog : public TQDialog {
Q_OBJECT
  TQ_OBJECT
	
public:
	enum Operation { Rename, Skip, SkipAll, Overwrite, OverwriteAll, None };
	SavefileDialog(const TQString& file, TQWidget *parent=0, const char* name=0, bool modal=true);
	~SavefileDialog();
	Operation saveFileOperation();
	TQString   renameFile();
		
private slots:
	void slot_rename() {
		op=Rename; accept();
	}
	void slot_skip() {
		op=Skip; accept();
	}
	void slot_skipAll() {
		op=SkipAll; accept();
	}
	void slot_overwrite() {
		op=Overwrite; accept();
	}
	void slot_overwriteAll() {
		op=OverwriteAll; accept();
	}
	void slot_renameEnabled();
		
private:
	TQLineEdit *renameEdit;
	TQPushButton *renameBtn;
	Operation op;
};

}  // NameSpace KIPIKameraKlientPlugin

#endif

