/* ============================================================
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
// TQt
#include <tqstring.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqfileinfo.h>
#include <tqlabel.h>
#include <tqlayout.h>
// KDE
#include <klocale.h>
#include <kbuttonbox.h>
#include <kiconloader.h>
// Local
#include "savefiledialog.h"

namespace KIPIKameraKlientPlugin
{

SavefileDialog::SavefileDialog(const TQString& file, TQWidget *parent, const char* name, bool modal) : TQDialog(parent, name, modal) {
    TQFileInfo fileInfo(file);
    setCaption(i18n("File Already Exists"));
    TQLabel *descLbl = new TQLabel(i18n("The file '%1' already exists!").arg(fileInfo.absFilePath()), this);
    renameEdit = new TQLineEdit(this);
    renameEdit->setText(fileInfo.fileName());
    connect(renameEdit, TQT_SIGNAL(textChanged(const TQString &)), this, TQT_SLOT(slot_renameEnabled()));
    KButtonBox *bbox = new KButtonBox(this);
    renameBtn = bbox->addButton(i18n("Rename"), TQT_TQOBJECT(this), TQT_SLOT(slot_rename()), true);
    renameBtn->setEnabled(false);
    bbox->addButton(i18n("Skip"), TQT_TQOBJECT(this), TQT_SLOT(slot_skip()), false);
    bbox->addButton(i18n("Skip All"), TQT_TQOBJECT(this), TQT_SLOT(slot_skipAll()), true);
    bbox->addButton(i18n("Overwrite"), TQT_TQOBJECT(this), TQT_SLOT(slot_overwrite()), true);
    bbox->addButton(i18n("Overwrite All"), TQT_TQOBJECT(this), TQT_SLOT(slot_overwriteAll()), true);
    TQPushButton *cancelBtn = bbox->addButton(i18n("&Cancel"), TQT_TQOBJECT(this), TQT_SLOT(reject()), true);
    cancelBtn->setDefault(true);
    bbox->layout();
    TQGridLayout *layout = new TQGridLayout(this, 0, 0, 15);
    layout->addMultiCellWidget(descLbl, 0, 0, 0, 3);
    layout->addMultiCellWidget(renameEdit, 3, 3, 0, 3);
    layout->addMultiCellWidget(bbox, 4, 4, 0, 3);
}

SavefileDialog::~SavefileDialog() {
}

SavefileDialog::Operation SavefileDialog::saveFileOperation() {
    return op;
}

TQString SavefileDialog::renameFile() {
    return renameEdit->text();
}

void SavefileDialog::slot_renameEnabled() {
    renameBtn->setEnabled(true);
    renameBtn->setDefault(true);
}

}  // NameSpace KIPIKameraKlientPlugin

#include "savefiledialog.moc"
