/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2008-05-21
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef IMAGES_LIST_H
#define IMAGES_LIST_H

// TQt includes.

#include <tqlistview.h>
#include <tqwidget.h>
#include <tqpixmap.h>

// KDE includes.

#include <kurl.h>

class KFileItem;

namespace KIPI
{
    class Interface;
}

namespace KIPIFlickrExportPlugin
{

class ImagesPagePriv;

class ImagesListViewItem : public TQListViewItem
{

public:

    ImagesListViewItem(TQListView *view, const KURL& url);
    ~ImagesListViewItem();

    void setUrl(const KURL& url);
    KURL url() const;

    void setThumb(const TQPixmap& pix);

private:

    KURL m_url;
};

// ---------------------------------------------------------

class ImagesListView : public TQListView
{
    Q_OBJECT
  TQ_OBJECT

public:

    ImagesListView(TQWidget *parent);
    ~ImagesListView();

signals:

    void signalDropedItems(const KURL::List&);

private:

    void dragEnterEvent(TQDragEnterEvent *e);
    void dropEvent(TQDropEvent *e);
};

// ---------------------------------------------------------

class ImagesList : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:

    ImagesList(TQWidget* parent, KIPI::Interface *iface);
    ~ImagesList();

    KURL::List imageUrls() const;
    void removeItemByUrl(const KURL& url);

signals:

    void signalImageListChanged(bool);

public slots:

    void slotAddImages(const KURL::List& list);

private slots:

    void slotAddItems();
    void slotRemoveItems();
    void slotGotThumbnail(const KFileItem *item, const TQPixmap& pix);

private:

    ImagesPagePriv *d;
};

}  // namespace KIPIFlickrExportPlugin

#endif // IMAGES_LIST_H
