//////////////////////////////////////////////////////////////////////////////
//
//    FINDDUPPLICATEIMAGES.H
//
//    Copyright (C) 2001 Richard Groult <rgroult at jalix.org> (from ShowImg project)
//    Copyright (C) 2004 Gilles Caulier <caulier dot gilles at gmail dot com>
//    Copyright (C) 2004 Richard Groult <rgroult at jalix.org>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////


#ifndef FINDDUPPLICATEIMAGES_H
#define FINDDUPPLICATEIMAGES_H

// Include files for TQt

#include <tqobject.h>
#include <tqstring.h>
#include <tqthread.h>
#include <tqstringlist.h>
#include <tqptrvector.h>
#include <tqdict.h>

// Includes file for libKIPI.

#include <libkipi/interface.h>

class TQProgressDialog;
class TQFile;
class TQCustomEvent;
class TQMutex;

class KConfig;

namespace KIPIFindDupplicateImagesPlugin
{

class ImageSimilarityData;
class FindDuplicateDialog;
class CompareOperation;

class FindDuplicateImages : public TQObject, public TQThread
{
    Q_OBJECT
  TQ_OBJECT

public:
    FindDuplicateImages( KIPI::Interface* interface, TQObject *parent=0);
    ~FindDuplicateImages();

    virtual void run();

    bool execDialog();
    void showResult();
    void compareAlbums();// Launch the dialog box for Albums selection before comparison.
    void stopPlease();

public slots:
    void slotUpdateCache(TQStringList fromDirs);
    void slotClearCache(TQStringList fromDir);
    void slotClearAllCache(void);

protected:
    KConfig              *config;
    TQString               m_imagesFileFilter;
    TQProgressDialog      *pdCache;
    FindDuplicateDialog  *m_findDuplicateDialog;
    float                 m_approximateLevel;

    float image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b);
    void writeSettings(void);
    void readSettings(void);
    void updateCache(TQString fromDir);
    bool DeleteDir(TQString dirname);
    bool deldir(TQString dirname);

    TQStringList filesList;
    TQObject *parent_;
    TQDict < TQPtrVector < TQFile > > m_res;
    KIPI::Interface* m_interface;
    TQString m_cacheDir;

private:
    CompareOperation* m_compareOp;
};

}  // NameSpace KIPIFindDupplicateImagesPlugin

#endif  // FINDDUPPLICATEIMAGES_H

