/* ============================================================
 * File  : monthwidget.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-11-03
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef MONTHWIDGET_H
#define MONTHWIDGET_H

// TQt includes.

#include <tqframe.h>

// LibKipi includes

#include <libkipi/interface.h>

class TQPainter;
class TQPixmap;
class TQDragEnterEvent;
class TQDropEvent;
class TQMouseEvent;

class KURL;
class KFileItem;

namespace KIPICalendarPlugin
{

class MonthWidget : public TQFrame
{
    Q_OBJECT
  TQ_OBJECT

public:

    MonthWidget( KIPI::Interface* interface, TQWidget *parent, int month);
    ~MonthWidget();

    KURL imagePath();
    void setImage( const KURL& url );

protected:

    void drawContents(TQPainter *p);
    void dragEnterEvent(TQDragEnterEvent* event);
    void dropEvent(TQDropEvent* event);
    void mouseReleaseEvent(TQMouseEvent* e);

private:

    int      month_;
    KURL     imagePath_;
    TQPixmap *pixmap_;
    KIPI::Interface* interface_;
private slots:

   void slotGotThumbnaiL(const KFileItem* url, const TQPixmap& pix);
};

}  // NameSpace KIPICalendarPlugin

#endif /* MONTHWIDGET_H */
