/***************************************************************************
                          selectablearea.cpp  -  description
                             -------------------
    begin                : mer mar 5 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "selectablearea.h"
#include <tqframe.h>
//#include <kdebug.h>
#include "fwglobal.h"

SelectableArea::SelectableArea(TQWidget *parent, const char *name ) : KHTMLPart(parent,name) {
  view()->setFrameShape(TQFrame::NoFrame);
  view()->setMinimumSize(TQSize(1,1));
  view()->installEventFilter(this);
}

SelectableArea::~SelectableArea(){}

bool SelectableArea::eventFilter(TQObject *o, TQEvent *event){
  switch ( event->type() ) {
    case TQEvent::FocusIn : {
                                             view()->setFrameShape(TQFrame::Box);
                                             view()->setFrameShadow ( TQFrame::Plain );
                                             view()->setLineWidth(2);
                                             emit selected(m_idLabel);
                                             return true;
                                           };
                                           break;
    case TQEvent::FocusOut : {
                                               view()->setFrameShape(TQFrame::NoFrame);
                                               return true;
                                             }
                                             break;
    case TQEvent::Resize : {
                                          emit Resized( view()->geometry() );
                                          view()->hide();
                                          view()->show();
                                          return true;
                                         }
                                         break;
      default: return KHTMLPart::eventFilter( o, event );
  }
}

#include "selectablearea.moc"
