/***************************************************************************
                               debugmanager.h
                             ------------------
    begin                : 2004-03-12
    copyright            : (C) 2004 Linus McCabe <linus@mccabe.nu>

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/

#ifndef MYDEBUGMANAGER_H
#define MYDEBUGMANAGER_H

#include <tqobject.h>
#include <tqstring.h>
#include "debuggerinterface.h"
#include "debuggervariable.h"

class DebuggerManager;

class QuantaDebuggerInterface : public DebuggerInterface
{
    Q_OBJECT
  TQ_OBJECT

  private:
    DebuggerManager *m_manager;

  public:
    QuantaDebuggerInterface(TQObject *myparent, const char* name);
    ~QuantaDebuggerInterface();

    // Breakpoints
    void haveBreakpoint (const TQString& file, int line) ;
    void havenoBreakpoint (const TQString& file, int line) ;
    void refreshBreakpoints();

    // Public help functions
    bool showStatus(const TQString& message, bool log);
    bool setActiveLine (const TQString& file, int line) ;

    void enableAction(const TQString& action, bool enable);
    void fileOpened(const TQString& file) ;
    void sendRequest(const KURL &url);
    virtual const TQString activeFileParts(const TQString & str);

    // Watches handling
    //void preWatchUpdate();
    //void postWatchUpdate();
    DebuggerVariable* newDebuggerVariable(const TQString& name, const TQString& value, int type);
    DebuggerVariable* newDebuggerVariable(const TQString& name, const ValueList_t& values, int type);
    void showVariable(DebuggerVariable*);

    // Breakpoints
    void showBreakpoint(const DebuggerBreakpoint &bp);
    DebuggerBreakpoint * newDebuggerBreakpoint();
    DebuggerBreakpoint * findDebuggerBreakpoint(const TQString& key);
    void updateBreakpointKey(const DebuggerBreakpoint &bp, const TQString& newkey);

    // Backtrace
    void backtraceClear();
    void backtraceShow(long level, BacktraceType type, const TQString &filename, long line, const TQString& func);

    // Path mapping
    PathMapper* Mapper();
};

#endif

