/***************************************************************************
                          tlpeditors.cpp  -  description
                             -------------------
    begin                : gio apr 1 2004
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kpushbutton.h>
#include <kurl.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kimagefilepreview.h>

#include "qextfileinfo.h"
#include "tlpeditors.h"
#include "fontfamilychooser.h"
#include "project.h"
    
TLPEditor::TLPEditor(TQWidget *parent, const char* name) : miniEditor(parent,name){
  m_label = new TQLabel(this);
  m_le = new TQLineEdit(this);
  m_pb = new KPushButton(this);
  setSpacing( KDialog::spacingHint() );
}

TLPEditor::~TLPEditor(){
  delete m_label;
  delete m_le;
  delete m_pb;
}

void TLPEditor::setButtonIcon(TQString s){
  TQIconSet iconSet =  SmallIconSet(TQString::fromLatin1(s.ascii()));
  TQPixmap pixMap = iconSet.pixmap( TQIconSet::Small, TQIconSet::Normal );
  m_pb->setIconSet(iconSet);
  m_pb->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
}

void TLPEditor::setLabelText(TQString s){
  m_label->setText(s);
}

void TLPEditor::setToolTip(TQString s){
  TQToolTip::add(m_pb, s);
}

void TLPEditor::setWhatsThis(TQString s){
  TQWhatsThis::add(m_le,s);
}

URIEditor::URIEditor(TQWidget *parent, const char* name) : TLPEditor(parent,name){
  TQString whatsthis =i18n("With this line edit you can insert the URI of the resource you want to reach");  
  setWhatsThis(whatsthis);
  setLabelText(" Uri  :");
  setButtonIcon("fileopen");
  setToolTip(i18n("Open the URI selector"));
    
  connect(m_pb, TQT_SIGNAL(clicked()), this, TQT_SLOT(openFileDialog()));
}

void URIEditor::connectToPropertySetter(propertySetter* p){
  connect(this,TQT_SIGNAL(valueChanged(const TQString&)), p ,TQT_SIGNAL(valueChanged(const TQString&))); 
}

void URIEditor::setMode(const mode& m) { 
  m_Mode = m ; 
  if( m_Mode == Single )
    connect(m_le, TQT_SIGNAL(textChanged ( const TQString & )), this, TQT_SLOT(selectedURI(const TQString&)));
  else{
    connect(m_le, TQT_SIGNAL(textChanged ( const TQString & )), this, TQT_SLOT(selectedURIs(const TQStringList&))); 
  }  
}

void URIEditor::selectedURI(const TQString & s){
   KURL u;
   u.setPath(s);
   emit valueChanged("url(\'" + QExtFileInfo::toRelative(u, Project::ref()->projectBaseURL()).path() + "\')");
}

void URIEditor::selectedURIs(const TQStringList& s){
  KURL u;
  TQStringList selectedFiles = s,
                     selectedFilesWithURLFormat;
  for ( TQStringList::Iterator it = selectedFiles.begin(); it != selectedFiles.end(); ++it ){      
    u.setPath(*it);   
    selectedFilesWithURLFormat.append( "url(\'" + QExtFileInfo::toRelative(u, Project::ref()->projectBaseURL()).path() + "\')");
  }
  emit valueChanged(selectedFilesWithURLFormat.join(","));
}
 
void URIEditor::openFileDialog(){
  
  KFileDialog fd( Project::ref()->projectBaseURL().url(), "*.*", this, "file dialog", true );
  switch(m_resourceType) {
    case image :   {
                             fd.setFilter( "*.png *.gif *.jpg *.mng|" + i18n("Image Files") +" (*.png *.gif *.jpg *.mng)\n*.*|" + i18n("All Files")+(" (*.*)") );
                             KImageFilePreview *ip = new KImageFilePreview( &fd );
                             fd.setPreviewWidget( ip );
                            } 
                             break;
    case audio : {
                           fd.setFilter( "*.au *.aiff *.wav|" + i18n("Audio Files")+" (*.au *.aiff *.wav)\n*.*|" + i18n("All Files")+(" (*.*)") );

    
                         }
                         break; 
  //case mousePointer :   fd.setFilter( "*.|" + i18n("Mouse Pointers (*.)")+"\n*.*|" + i18n("All Files (*.*)") );break;
    case mousePointer :   fd.setFilter( "*.*|" + i18n("All Files")+(" (*.*)") );break;
    
    default:;
  }
    
  if( m_Mode == Single) 
    fd.setMode(KFile::File); 
  else 
    fd.setMode(KFile::Files);
 
  
  if( fd.exec() ){
    if( fd.mode() == KFile::File )
      selectedURI( fd.selectedFile() );
    else {
      selectedURIs( fd.selectedFiles() );
      /*TQStringList selectedFiles = fd.selectedFiles();
      KURL u;
      for ( TQStringList::Iterator it = selectedFiles.begin(); it != selectedFiles.end(); ++it ){      
        u.setPath(*it);   
      m_sFiles.append( "url(\'" + QExtFileInfo::toRelative(u, Project::ref()->projectBaseURL()).path() + "\')");
      }
      emit valueChanged(m_sFiles.join(","));*/
    }
  }
}

fontEditor::fontEditor(TQWidget *parent, const char* name) : TLPEditor(parent,name), m_initialValue(TQString()){
  TQString whatsthis =i18n("With this line edit you can insert the name of the font you want to use");  
  setWhatsThis(whatsthis);
  setLabelText(i18n("Font family:"));
  setButtonIcon("fonts");
  setToolTip(i18n("Open font family chooser"));
  connect(m_pb, TQT_SIGNAL(clicked()), this, TQT_SLOT(openFontChooser()));
  connect(m_le, TQT_SIGNAL(textChanged ( const TQString & )), this, TQT_SIGNAL( valueChanged( const TQString& ) ) );
}

void fontEditor::connectToPropertySetter(propertySetter* p){
  connect(this, TQT_SIGNAL(valueChanged(const TQString&)), p, TQT_SIGNAL(valueChanged(const TQString&))); 
}

void fontEditor::openFontChooser(){
  fontFamilyChooser dlg( this );
  dlg.setInitialValue(m_initialValue);
  if( dlg.exec() )
    emit valueChanged( dlg.fontList().join(", "));
}

#include "tlpeditors.moc"
