/***************************************************************************
                          csseditor.h  -  description
                             -------------------
    begin                : mer lug 23 11:20:17 CEST 2003
    copyright            : (C) 2003 by gulmini luciano    
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSSEDITOR_H
#define CSSEDITOR_H

#include <tqwidget.h>
#include "csseditors.h"
#include <tqdom.h>
#include <tqmap.h>
#include <tqlistview.h>
#include <tqsignal.h>

class propertySetter;
class KConfig;
class KHTMLPart;
class TQListViewItem;
class TQDomNodeList;
class TQVariant;
class TQMyHighlighter;


class myCheckListItem : public TQCheckListItem
{
  private:
    TQSignal *m_sig;
    unsigned int m_checkedChildren;

  public :
    myCheckListItem(TQCheckListItem * parent, const TQString & text);
    myCheckListItem(TQListView * parent, const TQString & text);
    ~myCheckListItem();
    void connect( TQObject *receiver, const char *member );
    void addCheckedChild();

  protected :
    virtual void activate();
    virtual void stateChange (bool);
};

/** CSSEditor is the base class of the project */
class CSSEditor : public CSSEditorS
{
  Q_OBJECT
  TQ_OBJECT
  private:
    TQMyHighlighter *m_myhi;
    propertySetter *m_ps;
    myCheckListItem *m_currentProp;
    KHTMLPart *m_previewer;
    TQDomDocument m_doc;
    TQMap<TQString,TQString> m_properties;
    TQString m_selectorName,
                 m_initialProperties,
                 m_Selectors,
                 m_Header,
                 m_Footer,
                 
                 m_InlineStyleContent,
                 m_externalStyleSheetDefinition,
                 m_fileToPreview;
           
    bool m_isFileToPreviewExternal;                              
    KConfig *m_config;
     
            //sourceFileName;   
   
    void Connect();
    void appendSub(TQDomNodeList, myCheckListItem *);
    void buildListView(TQDomNodeList, TQListView *);
    void updateDisplay();    
    void activatePreview();
    void setCurrentPropOn(const TQString& s);
    void addProperty(const TQString& property, const TQString& value) { m_properties[property] = value; }
    void addAndSetPropertyOn(const TQString& property, const TQString& value);
    void setSidesOfPropertyBorderOn(const TQString& s);

  private slots:
    void checkProperty(const TQString&);   
    void removeProperty(const TQVariant&); 
    void updatePreview();
    void setMiniEditors(TQListViewItem*);
    void toggleShortendForm();
    
  public:
    
    CSSEditor(TQWidget* parent=0, const char *name=0): CSSEditorS(parent, name), m_config(0L){}
    CSSEditor( TQListViewItem * i, TQWidget* parent=0, const char *name=0);
    ~CSSEditor(); 
    void initialize();
    void setSelectors( const TQString& s) { m_Selectors = s; }
    void setHeader( const TQString& s) { m_Header = s; }
    void setFooter( const TQString& s) { m_Footer = s;}
    void setInlineStyleContent( const TQString& s){ m_InlineStyleContent = s; }
    TQString generateProperties();
    void hidePreviewer();
    void setFileToPreview(const TQString& s,bool b) { m_fileToPreview = s; m_isFileToPreviewExternal = b;}                                                                         
    void setExternalStyleSheetDefinition(const TQString& s) { m_externalStyleSheetDefinition = s;}

  signals:
    void signalUpdatePreview();
};

#endif
