/***************************************************************************
                         pixmaplabel.cpp - Pixmap label widget 
                          -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqpixmap.h>

/* KDE INCLUDES */
#include <kglobal.h>
#include <kiconloader.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <specials.h>
#include "pixmaplabel.h"

PixmapLabel::PixmapLabel(TQWidget *a_parent, const char *a_name)
  : TQLabel(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  if (KommanderWidget::inEditor)
    setPixmap(KGlobal::iconLoader()->loadIcon("tux", KIcon::NoGroup, 128));
  setAutoResize(false);
}

PixmapLabel::~PixmapLabel()
{
}

TQString PixmapLabel::currentState() const
{
  return TQString("default");
}

bool PixmapLabel::isKommanderWidget() const
{
  return true;
}

TQStringList PixmapLabel::associatedText() const
{
  return KommanderWidget::associatedText();
}

void PixmapLabel::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void PixmapLabel::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString PixmapLabel::populationText() const
{
  return KommanderWidget::populationText();
}

void PixmapLabel::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void PixmapLabel::setWidgetText(const TQString& a_text)
{
  TQPixmap pixmap;
  if (pixmap.load(a_text))
    setPixmap(pixmap);
}

void PixmapLabel::showEvent(TQShowEvent *e)
{
  TQLabel::showEvent(e);
  emit widgetOpened();
}

void PixmapLabel::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool PixmapLabel::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::clear || f == DCOP::geometry;
}

TQString PixmapLabel::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::clear:
      setPixmap(TQPixmap());
      break;
    case DCOP::text:
      return text();
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "pixmaplabel.moc"
