//
// C++ Implementation: FontDialog
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "fontdialog.h"

#include "kommanderplugin.h"
#include "specials.h"

#include <kfontdialog.h>
#include <kiconloader.h>
#include <klocale.h>

enum Functions {
  FirstFunction = 139,
  SetFont,
  Family,
  PointSize,
  Bold,
  Italic,
  LastFunction
};

FontDialog::FontDialog(TQWidget *parent, const char *name)
 : TQLabel(parent, name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  if (KommanderWidget::inEditor)
  {
    setPixmap(KGlobal::iconLoader()->loadIcon("kfontcombo", KIcon::NoGroup, KIcon::SizeMedium));
    setFrameStyle(TQFrame::Box | TQFrame::Plain);
    setLineWidth(1);
    setFixedSize(pixmap()->size());
  }
  else
    setHidden(true);
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(SetFont, "setFont(TQString widget, TQString family, int pointSize, bool bold, bool italic)",
         i18n("Sets the default font for the dialog, by specifying the family, the size and other style options."), 2, 5);
  KommanderPlugin::registerFunction(Family, "family(TQString widget)",
         i18n("Returns the font family."), 1);
  KommanderPlugin::registerFunction(PointSize, "pointSize(TQString widget)",
         i18n("Returns the font size in point."), 1);
  KommanderPlugin::registerFunction(Bold, "bold(TQString widget)",
         i18n("Returns true, if the font is bold."), 1);
  KommanderPlugin::registerFunction(Italic, "italic(TQString widget)",
         i18n("Returns true, if the font is italic."), 1);
}

FontDialog::~FontDialog()
{
}

TQString FontDialog::currentState() const
{
  return TQString("default");
}

bool FontDialog::isKommanderWidget() const
{
  return true;
}

TQStringList FontDialog::associatedText() const
{
  return KommanderWidget::associatedText();
}

void FontDialog::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void FontDialog::setWidgetText(const TQString& a_text)
{
  KommanderWidget::setAssociatedText(a_text);
}

void FontDialog::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString FontDialog::populationText() const
{
  return KommanderWidget::populationText();
}

void FontDialog::populate()
{
  setAssociatedText(KommanderWidget::evalAssociatedText( populationText()));
}

bool FontDialog::isFunctionSupported(int f)
{
  return (f > FirstFunction && f < LastFunction) || f == DCOP::execute;
}

TQString FontDialog::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case SetFont:
    {
      m_font.setFamily(args[0]);
      if (args[1].isEmpty())
        m_font.setPointSize(12);
      else
        m_font.setPointSize(args[1].toInt());
      m_font.setBold(args[2] == "1" || args[2].upper() == "TRUE");
      m_font.setItalic(args[3] == "1" || args[3].upper() == "TRUE");
      break;
    }
    case Family:
    {
      return m_font.family();
      break;
    }
    case PointSize:
    {
      return TQString::number(m_font.pointSize());
      break;
    }
    case Bold:
    {
      return m_font.bold() ? "1" : "0";
    }
    case Italic:
    {
      return m_font.italic() ? "1" : "0";
    }
    case DCOP::execute:
    {
      int result = KFontDialog::getFont( m_font );
      if ( result == KFontDialog::Accepted )
      {
        return m_font.toString();
      } 
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}



#include "fontdialog.moc"
