/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "actionlistview.h"
#include <tqdragobject.h>
#include <tqheader.h>

#include <klocale.h>

ActionListView::ActionListView( TQWidget *parent, const char *name )
    : TQListView( parent, name )
{
    header()->setStretchEnabled( true );
    setRootIsDecorated( true );
    setSorting( -1 );
    connect( this, TQT_SIGNAL( contextMenuRequested( TQListViewItem *, const TQPoint &, int ) ),
	     this, TQT_SLOT( rmbMenu( TQListViewItem *, const TQPoint & ) ) );
}

ActionItem::ActionItem( TQListView *lv, TQAction *ac )
    : TQListViewItem( lv ), a( 0 ), g( 0 )
{
    if ( ac->inherits( TQACTIONGROUP_OBJECT_NAME_STRING ) )
	g = (QDesignerActionGroup*)ac;
    else
	a = (QDesignerAction*)ac;
    setDragEnabled( true );
}

ActionItem::ActionItem( TQListViewItem *i, TQAction *ac )
    : TQListViewItem( i ), a( 0 ), g( 0 )
{
    if ( ac->inherits( TQACTIONGROUP_OBJECT_NAME_STRING ) )
	g = (QDesignerActionGroup*)ac;
    else
	a = (QDesignerAction*)ac;
    setDragEnabled( true );
    moveToEnd();
}

void ActionItem::moveToEnd()
{
    TQListViewItem *i = this;
    while ( i->nextSibling() )
	i = i->nextSibling();
    if ( i != this )
	moveItem( i );
}

TQDragObject *ActionListView::dragObject()
{
    ActionItem *i = (ActionItem*)currentItem();
    if ( !i )
	return 0;
    TQStoredDrag *drag = 0;
    if ( i->action() ) {
	drag = new TQStoredDrag( "application/x-designer-actions", viewport() );
	TQString s = TQString::number( (long)i->action() ); // #### huha, that is evil
	drag->setEncodedData( TQCString( s.latin1() ) );
	drag->setPixmap( i->action()->iconSet().pixmap() );
    } else {
	drag = new TQStoredDrag( "application/x-designer-actiongroup", viewport() );
	TQString s = TQString::number( (long)i->actionGroup() ); // #### huha, that is evil
	drag->setEncodedData( TQCString( s.latin1() ) );
	drag->setPixmap( i->actionGroup()->iconSet().pixmap() );
    }
    return drag;
}

void ActionListView::rmbMenu( TQListViewItem *i, const TQPoint &p )
{
    TQPopupMenu *popup = new TQPopupMenu( this );
    popup->insertItem( i18n("New &Action" ), 0 );
    popup->insertItem( i18n("New Action &Group" ), 1 );
    popup->insertItem( i18n("New &Dropdown Action Group" ), 2 );
    if ( i ) {
	popup->insertSeparator();
	popup->insertItem( i18n("&Connect Action..." ), 3 );
	popup->insertSeparator();
	popup->insertItem( i18n("Delete Action" ), 4 );
    }
    int res = popup->exec( p );
    if ( res == 0 )
	emit insertAction();
    else if ( res == 1 )
	emit insertActionGroup();
    else if ( res == 2 )
	emit insertDropDownActionGroup();
    else if ( res == 3 )
	emit connectAction();
    else if ( res == 4 )
	emit deleteAction();
}
#include "actionlistview.moc"
