/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *   thanks: Roberto Raggi for TQSimpleRichText stuff                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __FILECREATE_LISTITEM_H__
#define __FILECREATE_LISTITEM_H__

#include <klistview.h>
#include <tqobject.h>

#include "filecreate_filetype.h"

class TQSimpleRichText;

namespace FileCreate {

class ListItem : public KListViewItem {

public:
  ListItem(TQListView *listview, const FileType *filetype);
  ListItem(ListItem *listitem, const FileType *filetype);
  virtual ~ListItem();

  const FileType *filetype() const { return m_filetype; }

  virtual void setup();
  virtual void setHeight( int height );
  virtual void paintCell( TQPainter* p, const TQColorGroup& gc, int column, int width, int align );
  virtual void prepareResize();

private:
  const FileType *m_filetype;
  int m_iconHeight;
  void init();
  TQSimpleRichText *m_filetypeRenderer;

};

}

#endif

