/***************************************************************************
 *   Copyright (C) 2004 by Mathieu Chouinard                               *
 *   mathieu.chouinard@kdemail.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "docpdfplugin.h"

#include <kurl.h>
#include <kaboutdata.h>
#include <kconfig.h>
#include <klocale.h>
#include <klistview.h>

#include <kdevgenericfactory.h>

static const KAboutData data("docpdfplugin", I18N_NOOP("PDF documentation plugin"), "1.0");
typedef KDevGenericFactory<DocPDFPlugin> DocPDFPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libdocpdfplugin, DocPDFPluginFactory(&data) )

DocPDFPlugin::DocPDFPlugin(TQObject* parent, const char* name, const TQStringList args)
    :DocumentationPlugin(DocPDFPluginFactory::instance()->config(), parent, name)
{
    setCapabilities(CustomDocumentationTitles | ProjectUserManual);
    autoSetup();
}

DocPDFPlugin::~DocPDFPlugin()
{
}

bool DocPDFPlugin::needRefreshIndex(DocumentationCatalogItem* item)
{
    return false;
}

TQString DocPDFPlugin::pluginName() const
{
    return i18n("PDF Documentation Collection");
}

DocumentationCatalogItem* DocPDFPlugin::createCatalog(KListView* contents, const TQString& title, const TQString& url)
{
    DocumentationCatalogItem *item = new DocumentationCatalogItem(this, contents, title);
    item->setURL(KURL(url));
    return item;
}

TQPair<KFile::Mode, TQString> DocPDFPlugin::catalogLocatorProps()
{
    return TQPair<KFile::Mode, TQString>(KFile::File, "*.pdf");
}

TQString DocPDFPlugin::catalogTitle(const TQString& /*url*/)
{
    return TQString();
}

TQStringList DocPDFPlugin::fullTextSearchLocations()
{
    return TQStringList();
}


void DocPDFPlugin::autoSetupPlugin()
{
    return;
}

void DocPDFPlugin::createIndex(IndexBox* /*index*/, DocumentationCatalogItem* /*item*/)
{
    return;
}

void DocPDFPlugin::createTOC(DocumentationCatalogItem* /*item*/)
{
    return;
}

void DocPDFPlugin::setCatalogURL(DocumentationCatalogItem* /*item*/)
{
    return;
}

ProjectDocumentationPlugin *DocPDFPlugin::projectDocumentationPlugin(ProjectDocType type)
{
    if (type == UserManual)
        return new ProjectDocumentationPlugin(this, type);
    return DocumentationPlugin::projectDocumentationPlugin(type);
}
