/***************************************************************************
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DCCOPTIONSPLUGIN_H
#define DCCOPTIONSPLUGIN_H

#include <kdialogbase.h>

#include "kdevcompileroptions.h"

class DccOptionsPlugin : public KDevCompilerOptions
{
    Q_OBJECT
  TQ_OBJECT

public:
    DccOptionsPlugin( TQObject *parent, const char *name, const TQStringList/* &args */);
    ~DccOptionsPlugin();

    virtual TQString exec(TQWidget *parent, const TQString &flags);
};

class GeneralTab;
class LinkerTab;
class LocationsTab;
class Locations2Tab;
class CodegenTab;
class DebugOptimTab;

class DccOptionsDialog : public KDialogBase
{
public:
    DccOptionsDialog( TQWidget *parent=0, const char *name=0 );
    ~DccOptionsDialog();

    void setFlags(const TQString &flags);
    TQString flags() const;

private:
    GeneralTab *general;
    LinkerTab *linker;
    LocationsTab *locations;
    Locations2Tab *locations2;
    CodegenTab *codegen;
    DebugOptimTab *debug_optim;
    TQStringList unrecognizedFlags;
};


#endif
