/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   Copyright (C) 2006 by Jens Dagerbo                                    *
*   jens.dagerbo@swipnet.se                                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include <tqdir.h>

#include <klistbox.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <kdeversion.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <klineedit.h>

#include <keditlistbox.h>

// should be included after possible KEditListBox redefinition
#include "settingsdialog.h"

#include <tqfile.h>
#include <tqregexp.h>
#include <tqlayout.h>
#include <tqcheckbox.h>

#include <cstdlib>

SettingsDialog::SettingsDialog( TQWidget* parent, const char* name, WFlags fl )
		: SettingsDialogBase( parent, name, fl )
{
	KURLRequester * req = new KURLRequester( this );
	req->setMode( KFile::Directory );
	KEditListBox::CustomEditor pCustomEditor;
	pCustomEditor = req->customEditor();
	elb = new KEditListBox( i18n( "Directories to Parse" ), pCustomEditor, this );

	grid->addMultiCellWidget( elb, 3, 3, 0, grid->numCols() );

	//	connect( dbName_edit, TQT_SIGNAL( textChanged( const TQString& ) ), this, TQT_SLOT( validate() ) );
	connect( elb->addButton(), TQT_SIGNAL( clicked() ), this, TQT_SLOT( validate() ) );
	connect( elb->removeButton(), TQT_SIGNAL( clicked() ), this, TQT_SLOT( validate() ) );
	connect( elb, TQT_SIGNAL( added( const TQString& ) ), this, TQT_SLOT( validateDirectory( const TQString& ) ) );
}

SettingsDialog::~SettingsDialog()
{}

TQString SettingsDialog::dbName( ) const
{
	return TQString();
// 	return dbName_edit->text();
}

TQStringList SettingsDialog::dirs( ) const
{
	return elb->items();
}

TQString SettingsDialog::filePattern( ) const
{
	return pattern_edit->text();
}

bool SettingsDialog::recursive( ) const
{
	return recursive_box->isChecked();
}

void SettingsDialog::validate()
{
// 	emit enabled( !dbName_edit->text().isEmpty() && elb->listBox() ->count() > 0 );
 	emit enabled( elb->listBox()->count() > 0 );
}

void SettingsDialog::validateDirectory( const TQString & dir )
{
	TQDir d( dir, TQString(), TQDir::DefaultSort, TQDir::Dirs );
	if ( !d.exists() )
	{
		elb->lineEdit() ->setText( dir );

		if ( TQListBoxItem * item = elb->listBox() ->findItem( dir, TQt::ExactMatch ) )
		{
			elb->listBox() ->removeItem( elb->listBox() ->index( item ) );
		}

		TQString errormsg = TQString( "<qt><b>%1</b> is not a directory</qt>" ).arg( dir );
		KMessageBox::error( 0, errormsg, "Couldn't find directory" );
	}
	emit enabled( elb->listBox()->count() > 0 );
}

#include "settingsdialog.moc" 
//kate: indent-mode csands; tab-width 4; space-indent off;




