// *************************************************************************
//                          gdboutputwidget.cpp  -  description
//                             -------------------
//    begin                : 10th April 2003
//    copyright            : (C) 2003 by John Birch
//    email                : jbb@kdevelop.org
// **************************************************************************
//
// **************************************************************************
// *                                                                        *
// *   This program is free software; you can redistribute it and/or modify *
// *   it under the terms of the GNU General Public License as published by *
// *   the Free Software Foundation; either version 2 of the License, or    *
// *   (at your option) any later version.                                  *
// *                                                                        *
// **************************************************************************

#ifndef _GDBOUTPUTWIDGET_H_
#define _GDBOUTPUTWIDGET_H_

#include <tqwidget.h>
#include <tqtextedit.h>
#include <tqtimer.h>
#include <tqstringlist.h>

class KHistoryCombo;

class TQTextEdit;
class TQToolButton;
class TQDomElement;

namespace GDBDebugger
{

class GDBOutputWidget : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    GDBOutputWidget( TQWidget *parent=0, const char *name=0 );
    ~GDBOutputWidget();

    void savePartialProjectSession(TQDomElement* el);
    void restorePartialProjectSession(const TQDomElement* el);

    void clear();

public slots:
    void slotInternalCommandStdout(const char* line);
    void slotUserCommandStdout(const char* line);
    void slotReceivedStderr(const char* line);
    void slotDbgStatus     (const TQString &status, int statusFlag);

    void slotGDBCmd();

    void flushPending();

protected:
    virtual void focusInEvent(TQFocusEvent *e);

signals:
    void userGDBCmd(const TQString &cmd);
    void breakInto();

private:

    TQString html_escape(const TQString& s);

    void newStdoutLine(const TQString& line, bool internal);

    /** Arranges for 'line' to be shown to the user.
        Adds 'line' to pendingOutput_ and makes sure
        updateTimer_ is running. */
    void showLine(const TQString& line);

    /** Makes 'l' no longer then 'max_size' by
        removing excessive elements from the top.
    */
    void trimList(TQStringList& l, unsigned max_size);

    KHistoryCombo*  m_userGDBCmdEditor;
    TQToolButton*    m_Interrupt;
    TQTextEdit*      m_gdbView;

    void setShowInternalCommands(bool);
    friend class OutputText;

    /** The output from user commands only and from
        all commands. We keep it here so that if we switch
        "Show internal commands" on, we can show previous 
        internal commands. 
    */
    TQStringList userCommands_, allCommands_;
    /** Same output, without any fancy formatting.  Keeping it
        here because I can't find any way to extract raw text,
        without formatting, out of TQTextEdit except for
        selecting everything and calling 'copy()'. The latter
        approach is just ugly.  */
    TQStringList userCommandsRaw_, allCommandsRaw_;


    /** For performance reasons, we don't immediately add new text
        to TQTExtEdit. Instead we add it to pendingOutput_ and 
        flush it on timer.
    */
    TQString pendingOutput_;
    TQTimer updateTimer_;

    bool showInternalCommands_;

    int maxLines_;
};

/** Add popup menu specific to gdb output window to TQTextEdit.
*/
class OutputText : public TQTextEdit
{
    Q_OBJECT
  TQ_OBJECT
public:
    OutputText(GDBOutputWidget* parent) 
    : TQTextEdit(parent), 
      parent_(parent)
    {}

    TQPopupMenu* createPopupMenu(const TQPoint& pos);

private slots:
    void copyAll();
    void toggleShowInternalCommands();

private:
    GDBOutputWidget* parent_;
};

}

#endif
