/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef SOURCEEDITOR_H
#define SOURCEEDITOR_H

#include "../interfaces/editorinterface.h"
#include <tqvbox.h>
#include <tqguardedptr.h>

class FormWindow;
class TQCloseEvent;
struct LanguageInterface;
class Project;
class SourceFile;

class SourceEditor : public TQVBox
{
    Q_OBJECT
  TQ_OBJECT

public:
    SourceEditor( TQWidget *parent, EditorInterface *iface, LanguageInterface *liface );
    ~SourceEditor();

    void setObject( TQObject *fw, Project *p );
    TQObject *object() const { return obj; }
    Project *project() const { return pro; }
    void setFunction( const TQString &func, const TQString &clss = TQString() );
    void setClass( const TQString &clss );
    void save();
    bool saveAs();
    void setModified( bool b );
    bool isModified() const;

    static TQString sourceOfObject( TQObject *fw, const TQString &lang, EditorInterface *iface, LanguageInterface *lIface );

    TQString language() const;
    void setLanguage( const TQString &l );

    void editCut();
    void editCopy();
    void editPaste();
    bool editIsUndoAvailable();
    bool editIsRedoAvailable();
    void editUndo();
    void editRedo();
    void editSelectAll();

    void configChanged();
    void refresh( bool allowSave );
    void resetContext();

    EditorInterface *editorInterface() const { return iFace; }

    void setFocus();
    int numLines() const;
    void saveBreakPoints();
    void clearStep();
    void clearStackFrame();
    void resetBreakPoints();

    TQString text() const;

    void checkTimeStamp();

    SourceFile *sourceFile() const;
    FormWindow *formWindow() const;

protected:
    void closeEvent( TQCloseEvent *e );


private:
    EditorInterface *iFace;
    LanguageInterface *lIface;
    TQGuardedPtr<TQObject> obj;
    Project *pro;
    TQString lang;
    TQGuardedPtr<TQWidget> editor;

};

#endif
