/**********************************************************************
** Copyright (C) 2001 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "filechooser.h"
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqfiledialog.h>
#include <tqlayout.h>

#include <kfiledialog.h>

FileChooser::FileChooser( TQWidget *parent, const char *name )
    : TQWidget( parent, name ), md( File )
{
    TQHBoxLayout *layout = new TQHBoxLayout( this );
    layout->setMargin( 0 );

    lineEdit = new TQLineEdit( this, "filechooser_lineedit" );
    layout->addWidget( lineEdit );

    connect( lineEdit, TQT_SIGNAL( textChanged( const TQString & ) ),
	     this, TQT_SIGNAL( fileNameChanged( const TQString & ) ) );

    button = new TQPushButton( "...", this, "filechooser_button" );
    button->setFixedWidth( button->fontMetrics().width( " ... " ) );
    layout->addWidget( button );

    connect( button, TQT_SIGNAL( clicked() ),
	     this, TQT_SLOT( chooseFile() ) );

    setFocusProxy( lineEdit );
}

void FileChooser::setMode( Mode m )
{
    md = m;
}

FileChooser::Mode FileChooser::mode() const
{
    return md;
}

void FileChooser::setFileName( const TQString &fn )
{
    lineEdit->setText( fn );
}

TQString FileChooser::fileName() const
{
    return lineEdit->text();
}

void FileChooser::chooseFile()
{
    TQString fn;
    if ( mode() == File )
	fn = KFileDialog::getOpenFileName( lineEdit->text(), TQString(), this );
    else
	fn = KFileDialog::getExistingDirectory( lineEdit->text(),this );

    if ( !fn.isEmpty() ) {
	lineEdit->setText( fn );
	emit fileNameChanged( fn );
    }
}

