/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jun 18 2003
 */



#ifndef TEXTBLOCK_H
#define TEXTBLOCK_H

#include <tqdom.h>
#include <tqobject.h>

class CodeDocument;

/**
  * class TextBlock
  * The fundemental unit of text within an output file containing code.
  */

class TextBlock : virtual public TQObject {
    friend class CodeGenObjectWithTextBlocks;
    friend class ClassifierCodeDocument;
    Q_OBJECT
  TQ_OBJECT
public:

    // Constructors/Destructors
    //

    /**
     * Constructors
     */
    explicit TextBlock ( CodeDocument * parent, const TQString & text = "");

    // destructor
    ~TextBlock ( );

    // Public attributes
    //

    // Public attribute accessor methods
    //

    /**
     * Set the value of m_text
     * The actual text of this code block.
     * @param new_var the new value of m_text
     */
    void setText ( const TQString &new_var );

    /**
     * Add text to this object.
         *
         */
    void appendText ( const TQString &new_text );

    /**
     * Get the value of m_text
     * The actual text of this code block.
     * @return the value of m_text
     */
    TQString getText ( ) const;

    /**
    * Get the tag of this text block. This tag
    * may be used to find this text block in the code document
    * to which it belongs.
    */
    TQString getTag( ) const;

    /**
     * Set the tag of this text block. This tag
     * may be used to find this text block in the code document
     * to which it belongs.
     */
    void setTag( const TQString &value );

    /**
     * Get the value of m_parentDoc
     * @return the value of m_parentDoc
         */
    CodeDocument * getParentDocument ( );

    /**
     * Set the value of m_writeOutText
     * Whether or not to include the text of this TextBlock into a file.
     * @param new_var the new value of m_writeOutText
     */
    void setWriteOutText ( bool new_var );

    /**
     * Get the value of m_writeOutText
     * Whether or not to include the text of this TextBlock into a file.
     * @return the value of m_writeOutText
     */
    bool getWriteOutText ( );

    /** Set how many times to indent this text block.
     * The amount of each indenatation is determined from the parent
     * codedocument codegeneration policy.
     */
    void setIndentationLevel ( int level );

    /** Get how many times to indent this text block.
     * The amount of each indenatation is determined from the parent
     * codedocument codegeneration policy.
     */
    int getIndentationLevel ( );

    /** Get the actual amount of indentation for a given level of indentation.
     */
    TQString getIndentationString ( int level = 0);

    /** Get how much a single "level" of indentation will actually indent.
     */
    TQString getIndentation();

    TQString getNewLineEndingChars ( );

    /** Format a long text string to be more readable.
     */
    // should be static
    TQString formatMultiLineText ( const TQString &text, const TQString &linePrefix,
                                  const TQString& breakStr,
                                  bool alwaysAddBreak = true, bool lastLineHasBreak = true);

    /** UnFormat a long text string. Typically, this means removing
     *  the indentaion (linePrefix) and/or newline chars from each line.
     *  If an indentation isnt specified, then the current indentation is used.
     */
    virtual TQString unformatText ( const TQString & text, const TQString & indent = "");

    /**
     * @return  TQString
     */
    virtual TQString toString ( );

    /** encode text for XML storage
     * we simply convert all types of newLines to the "\n" or &#010;
     * entity.
     */
    static TQString encodeText(const TQString& text , const TQString &endChars);


    /** decode text from XML storage
     * We simply convert all newLine entity &#010; to chosen line ending.
     */
    static TQString decodeText(const TQString& text, const TQString &endChars);

    /**
     * Save the XMI representation of this object
     */
    virtual void saveToXMI ( TQDomDocument & doc, TQDomElement & root ) = 0;

    /**
     * load params from the appropriate XMI element node.
     */
    virtual void loadFromXMI ( TQDomElement & root ) = 0;

    /** Determine if its OK to delete this textblock from the document.
     * Used by the text editor to know if deletion could cause a crash of
     * the program.
     */
    bool canDelete ();

    /** set the class attributes from a passed object
     */
    virtual void setAttributesFromObject (TextBlock * obj);

    /** Used by the CodeEditor. It provides it with an appropriate
     * starting string for a new line of text within the given textblock
     * (for example a string with the proper indentation).
     * If the indentation amount is '0' the current indentationString will
     * be used.
     */
    virtual TQString getNewEditorLine( int indentAmount = 0 );

    /** Ush. These are terrifically bad and must one day go away.
     * Both methods indicate the range of lines in this textblock
     * which may be edited by the codeeditor (assuming that any are
     * actually editable). The default case is no lines are editable.
     * The line numbering starts with '0' and a '-1' means no line
     * qualifies.
     */
    virtual int firstEditableLine();
    virtual int lastEditableLine();

protected:

    /** causes the text block to release all of its connections
     * and any other text blocks that it 'owns'.
     * needed to be called prior to deletion of the textblock.
     */
    virtual     void release ();

    /**
     * Set the value of m_parentDocument
     * @param new_var the new value of m_parentDoc
     */
    void setParentDocument ( CodeDocument * new_var );

    /** set attributes of the node that represents this class
     * in the XMI document.
     */
    virtual void setAttributesOnNode ( TQDomDocument & doc, TQDomElement & blockElement);

    /** set the class attributes of this object from
     * the passed element node.
     */
    virtual void setAttributesFromNode ( TQDomElement & element);

    bool m_canDelete;

private:

    // The actual text of this code block.
    TQString m_text;
    TQString m_tag;

    // Whether or not to include the text of this TextBlock into a file.
    bool m_writeOutText;

    int m_indentationLevel;
    CodeDocument * m_parentDocument;

    void initFields ( CodeDocument * doc);

};

#endif // TEXTBLOCK_H
