/***************************************************************************
                          rubycodegenerator.cpp
                          Derived from the Java code generator by thomas

    begin                : Thur Jul 21 2005
    author               : Richard Dale
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2006-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "rubycodegenerator.h"

// qt/kde includes
#include <tqregexp.h>
#include <kconfig.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

// local includes
#include "rubycodecomment.h"
#include "codeviewerdialog.h"
#include "../uml.h"

// Constructors/Destructors
//

RubyCodeGenerator::RubyCodeGenerator (TQDomElement & elem )
  : CodeGenerator(elem)
{
}

RubyCodeGenerator::RubyCodeGenerator ()
{
}

RubyCodeGenerator::~RubyCodeGenerator ( ) { }

//
// Methods
//

// Accessor methods
//

// return our language
Uml::Programming_Language RubyCodeGenerator::getLanguage() {
    return Uml::pl_Ruby;
}

// In the Java version, we make the ANT build file also available.
CodeViewerDialog * RubyCodeGenerator::getCodeViewerDialog ( TQWidget* parent, CodeDocument *doc,
        Settings::CodeViewerState state)
{
    CodeViewerDialog *dialog = new CodeViewerDialog(parent, doc, state);
    return dialog;
}


RubyCodeGenerationPolicy * RubyCodeGenerator::getRubyPolicy() {
    return dynamic_cast<RubyCodeGenerationPolicy*>(UMLApp::app()->getPolicyExt());
}

bool RubyCodeGenerator::getAutoGenerateAttribAccessors ( )
{
    return getRubyPolicy()->getAutoGenerateAttribAccessors ();
}

bool RubyCodeGenerator::getAutoGenerateAssocAccessors ( )
{
    return getRubyPolicy()->getAutoGenerateAssocAccessors ();
}

TQString RubyCodeGenerator::getListFieldClassName () {
    return TQString("Array");
}

// Other methods
//

TQString RubyCodeGenerator::cppToRubyType(const TQString &typeStr) {
    TQString type = cleanName(typeStr);
    type.replace("const ", "");
    type.replace(TQRegExp("[*&\\s]"), "");
    type.replace(TQRegExp("[<>]"), "_");
    type.replace(TQSTRINGLIST_OBJECT_NAME_STRING, "Array");
    type.replace(TQRegExp("^string$"),"String");
    type.replace(TQSTRING_OBJECT_NAME_STRING, "String");
    type.replace("bool", "true|false");
    type.replace(TQRegExp("^(uint|int|ushort|short|ulong|long)$"), "Integer");
    type.replace(TQRegExp("^(float|double)$"), "Float");
    type.replace(TQRegExp("^Q(?=[A-Z])"), "TQt::");
    type.replace(TQRegExp("^K(?!(DE|Parts|IO)"), "KDE::");

    return type;
}

TQString RubyCodeGenerator::cppToRubyName(const TQString &nameStr) {
    TQString name = cleanName(nameStr);
    name.replace(TQRegExp("^m_"), "");
    name.replace(TQRegExp("^[pbn](?=[A-Z])"), "");
    name = name.mid(0, 1).lower() + name.mid(1);
    return name;
}

/**
 * @return      ClassifierCodeDocument
 * @param       classifier
 */
CodeDocument * RubyCodeGenerator::newClassifierCodeDocument ( UMLClassifier * c)
{
    RubyClassifierCodeDocument * doc = new RubyClassifierCodeDocument(c);
    doc->initCodeClassFields();
    return doc;
}

/* These initializations are done in CodeGenFactory::createObject()
void RubyCodeGenerator::initFields() {
    UMLApp::app()->setPolicyExt ( new RubyCodeGenerationPolicy(UMLApp::app()->getConfig()) );
    // load Classifier documents from parent document
    initFromParentDocument();
}
 */

const TQStringList RubyCodeGenerator::reservedKeywords() const {

    static TQStringList keywords;

    if (keywords.isEmpty()) {
        keywords << "__FILE__"
        << "__LINE__"
        << "BEGIN"
        << "END"
        << "alias"
        << "and"
        << "begin"
        << "break"
        << "case"
        << "class"
        << "def"
        << "defined?"
        << "do"
        << "else"
        << "elsif"
        << "end"
        << "ensure"
        << "false"
        << "for"
        << "if"
        << "in"
        << "module"
        << "next"
        << "nil"
        << "not"
        << "or"
        << "redo"
        << "rescue"
        << "retry"
        << "return"
        << "self"
        << "super"
        << "then"
        << "true"
        << "undef"
        << "unless"
        << "until"
        << "when"
        << "while"
        << "yield";
    }

    return keywords;
}

#include "rubycodegenerator.moc"

