//
// C++ Interface: strategies
//
// Description: 
//
//
// Author: Andrea Rizzi <rizzi@kde.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef DBSE2_STRATEGIES_H
#define DBSE2_STRATEGIES_H

#include "database.h"
#include "chunk.h"
#include <tqobject.h>

class AbstractSearchAlgorithm : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
    public: 
    
    typedef TQValueList<QueryResult> ResultList;
    
    AbstractSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets)
    {
	di=dbi;
	settings=sets;
    }
    /**
      * this contains the algo and return some results.	
      */
    virtual DataBaseInterface::ResultList exec(const TQString& query)=0;	
    
    signals:
    void newResult(QueryResult);
    
    protected:
    DataBaseInterface *di;
    DBSESettings *settings;
    
};



class ExactSearchAlgorithm : public AbstractSearchAlgorithm
{
    Q_OBJECT
  TQ_OBJECT
    public: 
    ExactSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets) : AbstractSearchAlgorithm(dbi,sets) {}
    
    virtual DataBaseInterface::ResultList exec(const TQString& query);
};

class AlphaSearchAlgorithm : public AbstractSearchAlgorithm
{
   Q_OBJECT
  TQ_OBJECT
    public: 
    AlphaSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets) : AbstractSearchAlgorithm(dbi,sets) {}
    
    virtual DataBaseInterface::ResultList exec(const TQString& query);
};

class SentenceArchiveSearchAlgorithm : public AbstractSearchAlgorithm
{
   Q_OBJECT
  TQ_OBJECT
    public: 
    SentenceArchiveSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets) ;
    
    virtual DataBaseInterface::ResultList exec(const TQString& query);
};

class ChunkByChunkSearchAlgorithm : public AbstractSearchAlgorithm
{
    Q_OBJECT
  TQ_OBJECT
    public: 
    ChunkByChunkSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets);
    
    virtual DataBaseInterface::ResultList exec(const TQString& query);
    
    void setChunkFactory(AbstractChunkFactory *_factory)
    {
    factory=_factory;
    }
    protected:
    AbstractChunkFactory *factory;
};

class FuzzyChunkSearchAlgorithm : public AbstractSearchAlgorithm
{
    Q_OBJECT
  TQ_OBJECT
    public: 
    FuzzyChunkSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets);
    
    virtual DataBaseInterface::ResultList exec(const TQString& query);
    void setChunkFactory(AbstractChunkFactory *_factory)
    {
    factory=_factory;
    }
    protected:
    AbstractChunkFactory *factory;    
};

class GenericSearchAlgorithm : public AbstractSearchAlgorithm
{
  Q_OBJECT
  TQ_OBJECT
    public: 
    GenericSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets) ;
    
    virtual ResultList exec(const TQString& query);
    
    void addAlgorithm(AbstractSearchAlgorithm *algo);    
    void setMaxResultNumber(uint num){maxResults=num;}

    
    protected:
    TQValueList<AbstractSearchAlgorithm *> algoChain;
    uint maxResults;
 };


class CorrelationSearchAlgorithm : public AbstractSearchAlgorithm
{
  Q_OBJECT
  TQ_OBJECT
    public: 
    CorrelationSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets) : AbstractSearchAlgorithm(dbi,sets) {}
    virtual ResultList exec(const TQString& query);
};



class SingleWordSearchAlgorithm : public GenericSearchAlgorithm
{
  Q_OBJECT
  TQ_OBJECT
    public: 
    SingleWordSearchAlgorithm(DataBaseInterface *dbi,DBSESettings *sets);
    virtual DataBaseInterface::ResultList exec(const TQString& query);
  
    private:
    ExactSearchAlgorithm exact;
    AlphaSearchAlgorithm alpha;
    SentenceArchiveSearchAlgorithm sentence;
    CorrelationSearchAlgorithm corr;
  	ChunkByChunkSearchAlgorithm chunk;
	CaseBasedWordChunkFactory casefactory;
};


class UpdateChunkIndexAlgorithm
{
    
};



#endif //DBSE2_STRATEGIES_H
