#ifndef __displaymgrmdi_h__
#define __displaymgrmdi_h__

#include "displayMgr.h"
#include "mditoplevel.h"

class DisplayMgrMDI : public TQObject, public DisplayMgr
{
    Q_OBJECT
  TQ_OBJECT
public:
    DisplayMgrMDI();
    virtual ~DisplayMgrMDI();

    virtual void newTopLevel(TQWidget *, bool show = FALSE);
    virtual void removeTopLevel(TQWidget *);

    virtual void show(TQWidget *);
    virtual void hide(TQWidget *);
    virtual void raise(TQWidget *, bool takefocus = false);

    virtual void setCaption(TQWidget *, const TQString&);

public slots:
    virtual void slotCycleTabsLeft();
    virtual void slotCycleTabsRight();

protected slots:
    void reparentReq();
    void moveWindowLeft();
    void moveWindowRight();
    void setTabPosition(int);
    void setFullScreen(bool);

protected:
    void moveWindow(int step);
    void refreshMenuEntry();

private:
    MDITopLevel *topLevel();

    TQGuardedPtr<MDITopLevel> m_topLevel;
    int m_moveRightTab, m_moveLeftTab;
    TQPopupMenu *m_popupWindows;
};


#endif

