#include "page_font.h"
#include "tqapplication.h"
PageFont::PageFont( TQWidget *parent, const char *name ) : 
  TQWidget( parent, name)
{
  layout = new TQHBoxLayout(this);
  fontchooser = new KFontChooser(this);
  layout->addWidget(fontchooser);
  connect(fontchooser,TQT_SIGNAL(fontSelected ( const TQFont&)), this, TQT_SLOT(update())); 
}

PageFont::~PageFont( )
{
  
}

void PageFont::update( void ){
  emit modified();
}

void PageFont::saveConfig( void )
{
  ksopts->defaultFont = fontchooser->font();
  TQApplication::setFont(fontchooser->font(), true, "KSirc::TextView" );
}

void PageFont::readConfig(  const KSOColors * opts )
{
  /* Just set the font from the preferences */
  fontchooser->setFont( opts->defaultFont );
}

void PageFont::defaultConfig( void )
{
  fontchooser->setFont( ksopts->defaultFont );
}

#include "page_font.moc"
