/*
 *
 *            kPPP: A front end for pppd for the KDE project
 *
 * $Id$
 * 
 * Copyright (C) 1997 Bernd Johannes Wuebben 
 * wuebben@math.cornell.edu
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */


#ifndef _MODEMINFO_H_
#define _MODEMINFO_H_

#include <tqdialog.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqevent.h>
#include <tqtimer.h>
#include <kprogress.h>

const int NUM_OF_ATI = 8;


class ModemTransfer : public TQDialog {
  Q_OBJECT
  TQ_OBJECT
public:
  ModemTransfer(TQWidget *parent=0, const char *name=0);
  
public slots:
  void init();
  void readtty();
  void do_script();
  void time_out_slot();
  void cancelbutton();
  void readChar(unsigned char);

private:
  void ati_done();

protected:
  void closeEvent(TQCloseEvent *e);

private:
  int 	step;
  TQString readbuffer;

  TQPushButton *cancel;
  KProgress *progressBar;
  TQLabel *statusBar;

  TQTimer *timeout_timer;
  TQTimer *scripttimer;
  TQString ati_query_strings[NUM_OF_ATI];
};


class ModemInfo : public TQDialog {
  Q_OBJECT
  TQ_OBJECT
public:
  ModemInfo(TQWidget *parent=0, const char *name=0);

public:
  void setAtiString(int num, TQString s);

private:
  TQLabel *ati_label[NUM_OF_ATI];
  TQLineEdit *ati_label_result[NUM_OF_ATI];
};

#endif
