//---------------------------------------------------------------------------
//
//             kPPP: A pppd front end for the KDE project
//
//---------------------------------------------------------------------------
//
// (c) 1997-1998 Bernd Johannes Wuebben <wuebben@kde.org>
// (c) 1997-1999 Mario Weilguni <mweilguni@kde.org>
// (c) 1998-1999 Harri Porten <porten@kde.org>
//
// derived from Jay Painters "ezppp"
//
//---------------------------------------------------------------------------
//  
//  $Id$
//
//---------------------------------------------------------------------------
// 
//  This program is free software; you can redistribute it and-or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
// 
//  You should have received a copy of the GNU Library General Public
//  License along with this program; if not, write to the Free
//  Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
//---------------------------------------------------------------------------

#ifndef __ACCTSELECT__H__
#define __ACCTSELECT__H__

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqdir.h>

class TQCheckBox;
class TQComboBox;
class TQLabel;
class TQListView;
class TQListViewItem;

class AccountingSelector : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  AccountingSelector(TQWidget *parent = 0, bool _isnewaccount = false, const char *name = 0);
  ~AccountingSelector() {}

  bool save();

private:
  TQListViewItem *findByName(TQString name);
  void setupTreeWidget();
  void insertDir(TQDir, TQListViewItem * = 0);
  TQString fileNameToName(TQString);
  TQString nameToFileName(TQString);

private slots:
  void openURL(const TQString &);
  void enableItems(bool);
  void slotSelectionChanged(TQListViewItem* i);

private:
  TQCheckBox *enable_accounting;
  TQListView *tl;
  TQComboBox *use_vol;
  TQPixmap pmfolder, pmfile;
  TQLabel *selected;

  TQListViewItem *edit_item;
  TQString edit_s;
  bool isnewaccount;
};

#endif

