/*
  AIMAccount - Oscar Protocol Account

  Copyright (c) 2002 by Chris TenHarmsel <tenharmsel@staticmethod.net>

  Kopete    (c) 2002 by the Kopete developers  <kopete-devel@kde.org>

  *************************************************************************
  *                                                                       *
  * This program is free software; you can redistribute it and/or modify  *
  * it under the terms of the GNU General Public License as published by  *
  * the Free Software Foundation; either version 2 of the License, or     *
  * (at your option) any later version.                                   *
  *                                                                       *
  *************************************************************************

*/

#ifndef AIMACCOUNT_H
#define AIMACCOUNT_H

#include <tqdict.h>
#include <tqstring.h>
#include <tqwidget.h>
#include "oscartypeclasses.h"

#include "oscaraccount.h"
#include "oscarmyselfcontact.h"

namespace AIM
{
	namespace PrivacySettings
	{
		enum { AllowAll = 0, AllowMyContacts, AllowPremitList, BlockAll, BlockAIM, BlockDenyList };
	}
}

namespace Kopete
{
class Contact;
class Group;
class ChatSession;
}

class KAction;
class OscarContact;
class AIMContact;
class AIMAccount;
class AIMJoinChatUI;
class AIMChatSession;
class OscarVisibilityDialog;

class AIMMyselfContact : public OscarMyselfContact
{
Q_OBJECT
  TQ_OBJECT
public:
	AIMMyselfContact( AIMAccount *acct );
	void userInfoUpdated();
	void setOwnProfile( const TQString& newProfile );
	TQString userProfile();
	void setLastAwayMessage( const TQString& msg) {m_lastAwayMessage = msg;}
	TQString lastAwayMessage() { return m_lastAwayMessage; };

    virtual Kopete::ChatSession* manager( Kopete::Contact::CanCreateFlags = Kopete::Contact::CannotCreate,
                                          WORD exchange = 0, const TQString& room = TQString());

public slots:
    void sendMessage( Kopete::Message&, Kopete::ChatSession* session );
    void chatSessionDestroyed( Kopete::ChatSession* );

private:
	TQString m_profileString;
	AIMAccount* m_acct;
	/**
	 * There has GOT to be a better way to get this away message
	 */
	TQString m_lastAwayMessage;
    TQValueList<Kopete::ChatSession*> m_chatRoomSessions;


};

class AIMAccount : public OscarAccount
{
Q_OBJECT
  TQ_OBJECT

public:
	AIMAccount(Kopete::Protocol *parent, TQString accountID, const char *name=0L);
	virtual ~AIMAccount();

	// Accessor method for the action menu
	virtual KActionMenu* actionMenu();

	void setAway(bool away, const TQString &awayReason = TQString() );

	virtual void connectWithPassword( const TQString &password );

	void setUserProfile(const TQString &profile);
	
	void setPrivacySettings( int privacy );

public slots:
	/** Reimplementation from Kopete::Account */
	void setOnlineStatus( const Kopete::OnlineStatus& status, const TQString& reason = TQString() );
	void slotEditInfo();
	void slotGoOnline();

	void slotGlobalIdentityChanged( const TQString&, const TQVariant& );
	void slotBuddyIconChanged();

	void slotJoinChat();

protected slots:
	void slotGoAway(const TQString&);
    void joinChatDialogClosed( int );

	virtual void loginActions();
	virtual void disconnected( Kopete::Account::DisconnectReason reason );
	virtual void messageReceived( const Oscar::Message& message );

    void connectedToChatRoom( WORD exchange, const TQString& roomName );
    void userJoinedChat( Oscar::WORD exchange, const TQString& room, const TQString& contact );
    void userLeftChat( Oscar::WORD exchange, const TQString& room, const TQString& contact );

	void slotSetVisiblility();
	void slotVisibilityDialogClosed();

protected:

	/**
	* Implement virtual method from OscarAccount
	* This allows OscarAccount to take care of adding new contacts
	*/
	OscarContact *createNewContact( const TQString &contactId, Kopete::MetaContact *parentContact, const SSI& ssiItem );

	TQString sanitizedMessage( const TQString& message );

private:
	// Set privacy tlv item
	void setPrivacyTLVs( BYTE privacy, DWORD userClasses );

    AIMJoinChatUI* m_joinChatDialog;
	OscarVisibilityDialog* m_visibilityDialog;
};
#endif
//kate: tab-width 4; indent-mode csands;
