/*
    Kopete Groupwise Protocol
    createcontactinstancetask.h - Request Task that creates an instance of a contact on the server side contact list

    Copyright (c) 2004      SUSE Linux AG	 	 http://www.suse.com
    
    Based on Iris, Copyright (C) 2003  Justin Karneges

    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>
 
    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef CreateContactInstanceTask_H
#define CreateContactInstanceTask_H

#include "needfoldertask.h"

/**
Creates a contact on the server.  The response to this action is handled by its parent

@author SUSE AG
*/
class CreateContactInstanceTask : public NeedFolderTask
{
Q_OBJECT
  TQ_OBJECT
public:
	CreateContactInstanceTask(Task* parent);
	~CreateContactInstanceTask();
	/** 
	 * Sets up the request message.  
	 */
	void contactFromUserId( const TQString & userId, const TQString & displayName, const int parentFolder );
	void contactFromDN( const TQString & dn, const TQString & displayName, const int parentFolder );
	void contactFromUserIdAndFolder( const TQString & userId, const TQString & displayName, const int folderSequence, const TQString & folderDisplayName );
	void contactFromDNAndFolder( const TQString & dn, const TQString & displayName, const int folderSequence, const TQString & folderDisplayName );
	void onGo();
protected:
	void contact( Field::SingleField * id, const TQString & displayName, const int parentFolder );
	void onFolderCreated();
private:
	TQString m_userId;
	TQString m_dn;
	TQString m_displayName;
};

#endif
