/*
    highlightconfig.cpp

    Copyright (c) 2003      by Olivier Goffart       <ogoffart @ kde.org>
    Copyright (c) 2003      by Matt Rogers           <matt@matt.rogers.name>

    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqfile.h>
#include <tqstylesheet.h>
#include <tqregexp.h>
#include <tqdir.h>
#include <tqdom.h>

#include <ksavefile.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include "filter.h"
#include "highlightconfig.h"


HighlightConfig::HighlightConfig()
{
	load();
	m_filters.setAutoDelete(true);
}

HighlightConfig::~HighlightConfig()
{
	m_filters.clear();
}

void HighlightConfig::removeFilter(Filter *f)
{
    //m_filters is "autodelete (true) so when we use remove(...) it deleted f
    //so don't use (delete (f) after otherwise ot crash
	m_filters.remove(f);
}

void HighlightConfig::appendFilter(Filter *f)
{
	m_filters.append(f);
}

TQPtrList<Filter> HighlightConfig::filters() const
{
	return m_filters;
}

Filter* HighlightConfig::newFilter()
{
	Filter *filtre=new Filter();
	filtre->caseSensitive=false;
	filtre->isRegExp=false;
	filtre->setImportance=false;
	filtre->importance=1;
	filtre->setBG=false;
	filtre->setFG=false;
	filtre->playSound=false;
	filtre->raiseView=false;
	filtre->displayName=i18n("-New filter-");
	m_filters.append(filtre);
	return filtre;
}

void HighlightConfig::load()
{
	m_filters.clear(); //clear filters

	TQString filename = locateLocal( "appdata", TQString::fromLatin1( "highlight.xml" ) );
	if( filename.isEmpty() )
		return ;

	TQDomDocument filterList( TQString::fromLatin1( "highlight-plugin" ) );

	TQFile filterListFile( filename );
	filterListFile.open( IO_ReadOnly );
	filterList.setContent( &filterListFile );

	TQDomElement list = filterList.documentElement();

	TQDomNode node = list.firstChild();
	while( !node.isNull() )
	{
		TQDomElement element = node.toElement();
		if( !element.isNull() )
		{
//			if( element.tagName() == TQString::fromLatin1("filter")
//			{
				Filter *filtre=newFilter();
				TQDomNode filterNode = node.firstChild();

				while( !filterNode.isNull() )
				{
					TQDomElement filterElement = filterNode.toElement();
					if( !filterElement.isNull() )
					{
						if( filterElement.tagName() == TQString::fromLatin1( "display-name" ) )
						{
							filtre->displayName = filterElement.text();
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "search" ) )
						{
							filtre->search = filterElement.text();

							filtre->caseSensitive= ( filterElement.attribute( TQString::fromLatin1( "caseSensitive" ), TQString::fromLatin1( "1" ) ) == TQString::fromLatin1( "1" ) );
							filtre->isRegExp= ( filterElement.attribute( TQString::fromLatin1( "regExp" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "FG" ) )
						{
							filtre->FG = filterElement.text();
							filtre->setFG= ( filterElement.attribute( TQString::fromLatin1( "set" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "BG" ) )
						{
							filtre->BG = filterElement.text();
							filtre->setBG= ( filterElement.attribute( TQString::fromLatin1( "set" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "importance" ) )
						{
							filtre->importance = filterElement.text().toUInt();
							filtre->setImportance= ( filterElement.attribute( TQString::fromLatin1( "set" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "sound" ) )
						{
							filtre->soundFN = filterElement.text();
							filtre->playSound = ( filterElement.attribute( TQString::fromLatin1( "set" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
						else if( filterElement.tagName() == TQString::fromLatin1( "raise" ) )
						{
							filtre->raiseView = ( filterElement.attribute( TQString::fromLatin1( "set" ), TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
						}
					}
					filterNode = filterNode.nextSibling();
				}
//			}
		}
		node = node.nextSibling();
	}
	filterListFile.close();
}

void HighlightConfig::save()
{

	TQString fileName = locateLocal( "appdata", TQString::fromLatin1( "highlight.xml" ) );

	KSaveFile file( fileName );
	if( file.status() == 0 )
	{
		TQTextStream *stream = file.textStream();
		stream->setEncoding( TQTextStream::UnicodeUTF8 );

		TQString xml = TQString::fromLatin1(
			"<?xml version=\"1.0\"?>\n"
			"<!DOCTYPE kopete-highlight-plugin>\n"
			"<highlight-plugin>\n" );

			// Save metafilter information.
		TQPtrListIterator<Filter> filtreIt( m_filters );
		for( ; filtreIt.current(); ++filtreIt )
		{
			Filter *filtre = *filtreIt;
			xml += TQString::fromLatin1( "  <filter>\n    <display-name>" )
				+ TQStyleSheet::escape(filtre->displayName)
				+ TQString::fromLatin1( "</display-name>\n" );

			xml += TQString::fromLatin1("    <search caseSensitive=\"") + TQString::number( static_cast<int>( filtre->caseSensitive ) ) +
				TQString::fromLatin1("\" regExp=\"") + TQString::number( static_cast<int>( filtre->isRegExp ) ) +
				TQString::fromLatin1( "\">" ) + TQStyleSheet::escape( filtre->search ) + TQString::fromLatin1( "</search>\n" );

			xml += TQString::fromLatin1("    <BG set=\"") + TQString::number( static_cast<int>( filtre->setBG ) ) +
				TQString::fromLatin1( "\">" ) + TQStyleSheet::escape( filtre->BG.name() ) + TQString::fromLatin1( "</BG>\n" );
			xml += TQString::fromLatin1("    <FG set=\"") + TQString::number( static_cast<int>( filtre->setFG ) ) +
				TQString::fromLatin1( "\">" ) + TQStyleSheet::escape( filtre->FG.name() ) + TQString::fromLatin1( "</FG>\n" );

			xml += TQString::fromLatin1("    <importance set=\"") + TQString::number( static_cast<int>( filtre->setImportance ) ) +
				TQString::fromLatin1( "\">" ) + TQString::number( filtre->importance ) + TQString::fromLatin1( "</importance>\n" );

			xml += TQString::fromLatin1("    <sound set=\"") + TQString::number( static_cast<int>( filtre->playSound ) ) +
				TQString::fromLatin1( "\">" ) + TQStyleSheet::escape( filtre->soundFN ) + TQString::fromLatin1( "</sound>\n" );

			xml += TQString::fromLatin1("    <raise set=\"") + TQString::number( static_cast<int>( filtre->raiseView ) ) +
				TQString::fromLatin1( "\"></raise>\n" );

			xml += TQString::fromLatin1( "  </filter>\n" );
		}

		xml += TQString::fromLatin1( "</highlight-plugin>\n" );

		*stream << xml;
	}
}

// vim: set noet ts=4 sts=4 sw=4:
