/*
    emoticonselector.h

    a button that pops up a list of all emoticons and returns
    the emoticon-string if one is selected in the list

    Copyright (c) 2002 by Stefan Gehn            <metz AT gehn.net>
    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef __emoticonselector_h__
#define __emoticonselector_h__

#include <tqlabel.h>
#include <tqwidget.h>
class TQGridLayout;
class TQHideEvent;
class TQShowEvent;

class EmoticonLabel : public TQLabel
{
	Q_OBJECT
  TQ_OBJECT

public:
	EmoticonLabel(const TQString &emoticonText, const TQString &pixmapPath, TQWidget *parent=0, const char *name=0);
//	~EmoticonLabel();

signals:
	void clicked(const TQString &text);

protected:
	void mouseReleaseEvent(TQMouseEvent*);
	TQString mText;
};

class EmoticonSelector : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

public:

	EmoticonSelector ( TQWidget *parent = 0, const char *name = 0 );
//	~EmoticonSelector();

	typedef TQValueList<TQMovie*> MovieList;
signals:
	/**
	* gets emitted when an emoticon has been selected from the list
	* the TQString holds the emoticon as a string or is 0L if nothing was selected
	**/
	void ItemSelected(const TQString &);

public slots:
	void prepareList();

protected:
	virtual void hideEvent( TQHideEvent* );
	virtual void showEvent( TQShowEvent* );
	MovieList movieList;
	TQGridLayout *lay;

protected slots:
	void emoticonClicked(const TQString &);
};

#endif
// vim: set noet ts=4 sts=4 sw=4:
