/***************************************************************************
*                                logwindow.h
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/


#ifndef _LOGWINDOW_H
#define _LOGWINDOW_H

#include <tqmap.h>

#include <kdialogbase.h>

class TQListView;
class TQTextEdit;


class SeparatedLog:public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
    SeparatedLog(TQWidget * parent);
    ~SeparatedLog()
    {}
    void addLog(uint id, const TQString & filename, const TQString & message);
    void refresh();

protected slots:
    void transferSelected(TQListViewItem * item);

private:
    TQListView * lv_log;
    TQTextEdit *ml_log;

    typedef TQMap < uint, TQString > TransferMap;
    TransferMap trMap;

    uint idSelected;
};


class LogWindow:public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT
public:
    LogWindow();
    ~LogWindow()
    {}
    void logGeneral(const TQString & message);
    TQString getText() const;

public slots:
    void logTransfer(uint id, const TQString & filename, const TQString & message);

protected:
    void closeEvent(TQCloseEvent *);

private:
    TQTextEdit * mixed_log;
    SeparatedLog *sep_log;
};


#endif                          // _LOGWINDOW_H
